/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.chains.autoloading;

import de.quantummaid.httpmaid.util.Validators;
import lombok.Generated;

public final class MavenDependency {
    private final String groupId;
    private final String artifactId;
    private final String version;

    public static MavenDependency mavenDependency(String groupId, String artifactId, String version) {
        Validators.validateNotNullNorEmpty(groupId, "groupId");
        Validators.validateNotNullNorEmpty(artifactId, "artifactId");
        Validators.validateNotNullNorEmpty(version, "version");
        return new MavenDependency(groupId, artifactId, version);
    }

    public String render() {
        return String.format("<dependency>%n   <groupId>%s</groupId>%n   <artifactId>%s</artifactId>%n   <version>%s</version>%n</dependency>%n", this.groupId, this.artifactId, this.version);
    }

    @Generated
    public String toString() {
        return "MavenDependency(groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MavenDependency)) {
            return false;
        }
        MavenDependency other = (MavenDependency)o;
        String this$groupId = this.groupId;
        String other$groupId = other.groupId;
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.artifactId;
        String other$artifactId = other.artifactId;
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.version;
        String other$version = other.version;
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.groupId;
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.artifactId;
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.version;
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    @Generated
    private MavenDependency(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }
}

