/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.cors;

import de.quantummaid.httpmaid.chains.ChainModule;
import de.quantummaid.httpmaid.chains.Configurator;
import de.quantummaid.httpmaid.chains.DependencyRegistry;
import de.quantummaid.httpmaid.cors.CorsModule;
import de.quantummaid.httpmaid.cors.domain.ExposedHeader;
import de.quantummaid.httpmaid.cors.domain.ExposedHeaders;
import de.quantummaid.httpmaid.cors.domain.MaxAge;
import de.quantummaid.httpmaid.cors.domain.RequestedHeader;
import de.quantummaid.httpmaid.cors.policy.AllowedHeaders;
import de.quantummaid.httpmaid.cors.policy.AllowedMethods;
import de.quantummaid.httpmaid.cors.policy.AllowedOrigins;
import de.quantummaid.httpmaid.cors.policy.ResourceSharingPolicy;
import de.quantummaid.httpmaid.http.HttpRequestMethod;
import de.quantummaid.httpmaid.util.Validators;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;

public final class CorsConfigurator
implements Configurator {
    private final AllowedOrigins allowedOrigins;
    private volatile AllowedMethods allowedMethods;
    private volatile AllowedHeaders allowedHeaders;
    private volatile ExposedHeaders exposedHeaders;
    private volatile boolean credentialsSupport = false;
    private volatile MaxAge maxAge = MaxAge.undefinedMaxAge();

    public static CorsConfigurator corsConfigurator(AllowedOrigins allowedOrigins) {
        Validators.validateNotNull(allowedOrigins, "allowedOrigins");
        CorsConfigurator corsConfigurator = new CorsConfigurator(allowedOrigins);
        return corsConfigurator.withAllowedMethods(HttpRequestMethod.GET, HttpRequestMethod.POST).withAllowedHeaders(new String[0]).exposingTheResponseHeaders(new String[0]);
    }

    public CorsConfigurator withAllowedMethods(HttpRequestMethod ... methods) {
        Validators.validateNotNull(methods, "methods");
        List<HttpRequestMethod> methodList = Arrays.asList(methods);
        this.allowedMethods = requestedMethod -> methodList.parallelStream().anyMatch(requestedMethod::matches);
        return this;
    }

    public CorsConfigurator allowingAllHeaders() {
        this.allowedHeaders = requestedHeader -> true;
        return this;
    }

    public CorsConfigurator withAllowedHeaders(String ... headers) {
        Validators.validateNotNull(headers, "headers");
        List allowedHeaders = Arrays.stream(headers).map(RequestedHeader::requestedHeader).collect(Collectors.toList());
        this.allowedHeaders = allowedHeaders::contains;
        return this;
    }

    public CorsConfigurator exposingTheResponseHeaders(String ... exposedHeaders) {
        this.exposedHeaders = ExposedHeaders.exposedHeaders(Arrays.stream(exposedHeaders).map(ExposedHeader::exposedHeader).collect(Collectors.toList()));
        return this;
    }

    public CorsConfigurator exposingAllResponseHeaders() {
        return this.exposingTheResponseHeaders("*");
    }

    public CorsConfigurator allowingCredentials() {
        this.credentialsSupport = true;
        return this;
    }

    public CorsConfigurator notAllowingCredentials() {
        this.credentialsSupport = false;
        return this;
    }

    public CorsConfigurator withTimeOutAfter(int timeout, TimeUnit timeUnit) {
        long seconds = timeUnit.toSeconds(timeout);
        this.maxAge = MaxAge.maxAgeInSeconds(seconds);
        return this;
    }

    @Override
    public List<ChainModule> supplyModulesIfNotAlreadyPresent() {
        return Collections.singletonList(CorsModule.corsModule());
    }

    @Override
    public void configure(DependencyRegistry dependencyRegistry) {
        CorsModule corsModule = dependencyRegistry.getDependency(CorsModule.class);
        ResourceSharingPolicy resourceSharingPolicy = ResourceSharingPolicy.resourceSharingPolicy(this.allowedOrigins, this.allowedMethods, this.allowedHeaders, this.exposedHeaders, this.credentialsSupport, this.maxAge);
        corsModule.setResourceSharingPolicy(resourceSharingPolicy);
    }

    @Generated
    public String toString() {
        return "CorsConfigurator(allowedOrigins=" + this.allowedOrigins + ", allowedMethods=" + this.allowedMethods + ", allowedHeaders=" + this.allowedHeaders + ", exposedHeaders=" + this.exposedHeaders + ", credentialsSupport=" + this.credentialsSupport + ", maxAge=" + this.maxAge + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CorsConfigurator)) {
            return false;
        }
        CorsConfigurator other = (CorsConfigurator)o;
        AllowedOrigins this$allowedOrigins = this.allowedOrigins;
        AllowedOrigins other$allowedOrigins = other.allowedOrigins;
        if (this$allowedOrigins == null ? other$allowedOrigins != null : !this$allowedOrigins.equals(other$allowedOrigins)) {
            return false;
        }
        AllowedMethods this$allowedMethods = this.allowedMethods;
        AllowedMethods other$allowedMethods = other.allowedMethods;
        if (this$allowedMethods == null ? other$allowedMethods != null : !this$allowedMethods.equals(other$allowedMethods)) {
            return false;
        }
        AllowedHeaders this$allowedHeaders = this.allowedHeaders;
        AllowedHeaders other$allowedHeaders = other.allowedHeaders;
        if (this$allowedHeaders == null ? other$allowedHeaders != null : !this$allowedHeaders.equals(other$allowedHeaders)) {
            return false;
        }
        ExposedHeaders this$exposedHeaders = this.exposedHeaders;
        ExposedHeaders other$exposedHeaders = other.exposedHeaders;
        if (this$exposedHeaders == null ? other$exposedHeaders != null : !((Object)this$exposedHeaders).equals(other$exposedHeaders)) {
            return false;
        }
        if (this.credentialsSupport != other.credentialsSupport) {
            return false;
        }
        MaxAge this$maxAge = this.maxAge;
        MaxAge other$maxAge = other.maxAge;
        return !(this$maxAge == null ? other$maxAge != null : !((Object)this$maxAge).equals(other$maxAge));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AllowedOrigins $allowedOrigins = this.allowedOrigins;
        result = result * 59 + ($allowedOrigins == null ? 43 : $allowedOrigins.hashCode());
        AllowedMethods $allowedMethods = this.allowedMethods;
        result = result * 59 + ($allowedMethods == null ? 43 : $allowedMethods.hashCode());
        AllowedHeaders $allowedHeaders = this.allowedHeaders;
        result = result * 59 + ($allowedHeaders == null ? 43 : $allowedHeaders.hashCode());
        ExposedHeaders $exposedHeaders = this.exposedHeaders;
        result = result * 59 + ($exposedHeaders == null ? 43 : ((Object)$exposedHeaders).hashCode());
        result = result * 59 + (this.credentialsSupport ? 79 : 97);
        MaxAge $maxAge = this.maxAge;
        result = result * 59 + ($maxAge == null ? 43 : ((Object)$maxAge).hashCode());
        return result;
    }

    @Generated
    private CorsConfigurator(AllowedOrigins allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }
}

