/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.handler.distribution;

import de.quantummaid.httpmaid.chains.MetaDataKey;
import de.quantummaid.httpmaid.generator.GenerationCondition;
import de.quantummaid.httpmaid.util.Validators;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;

public final class RegisteredHandlers {
    public static final MetaDataKey<RegisteredHandlers> REGISTERED_HANDLERS = MetaDataKey.metaDataKey("REGISTERED_HANDLERS");
    private final Map<GenerationCondition, Object> handlers;

    public static RegisteredHandlers registeredHandlers() {
        return new RegisteredHandlers(new HashMap<GenerationCondition, Object>());
    }

    public void register(GenerationCondition condition, Object handler) {
        Validators.validateNotNull(condition, "condition");
        Validators.validateNotNull(handler, "handler");
        this.handlers.put(condition, handler);
    }

    public Map<GenerationCondition, Object> allHandlersThat(Predicate<Object> predicate) {
        return this.handlers.entrySet().stream().filter(entry -> predicate.test(entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Generated
    public String toString() {
        return "RegisteredHandlers(handlers=" + this.handlers + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegisteredHandlers)) {
            return false;
        }
        RegisteredHandlers other = (RegisteredHandlers)o;
        Map<GenerationCondition, Object> this$handlers = this.handlers;
        Map<GenerationCondition, Object> other$handlers = other.handlers;
        return !(this$handlers == null ? other$handlers != null : !((Object)this$handlers).equals(other$handlers));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<GenerationCondition, Object> $handlers = this.handlers;
        result = result * 59 + ($handlers == null ? 43 : ((Object)$handlers).hashCode());
        return result;
    }

    @Generated
    private RegisteredHandlers(Map<GenerationCondition, Object> handlers) {
        this.handlers = handlers;
    }
}

