/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.marshalling.urlencoded;

import de.quantummaid.httpmaid.marshalling.urlencoded.Key;
import de.quantummaid.httpmaid.util.Validators;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import lombok.Generated;

final class KeyValue {
    private final Key key;
    private final String value;

    static KeyValue keyValue(Key key, String value) {
        Validators.validateNotNull(key, "key");
        Validators.validateNotNull(value, "value");
        return new KeyValue(key, value);
    }

    static KeyValue parse(String keyAndValue) {
        String[] split = keyAndValue.split("=");
        String key = URLDecoder.decode(split[0], StandardCharsets.UTF_8);
        String value = split.length > 1 ? URLDecoder.decode(split[1], StandardCharsets.UTF_8) : "";
        return KeyValue.keyValue(Key.parseKey(key), value);
    }

    Key key() {
        return this.key;
    }

    String value() {
        return this.value;
    }

    String render() {
        String encodedKey = this.key.render();
        String encodedValue = URLEncoder.encode(this.value, StandardCharsets.UTF_8);
        return String.format("%s=%s", encodedKey, encodedValue);
    }

    @Generated
    public String toString() {
        return "KeyValue(key=" + this.key + ", value=" + this.value + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyValue)) {
            return false;
        }
        KeyValue other = (KeyValue)o;
        Key this$key = this.key;
        Key other$key = other.key;
        if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
            return false;
        }
        String this$value = this.value;
        String other$value = other.value;
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Key $key = this.key;
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        String $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Generated
    private KeyValue(Key key, String value) {
        this.key = key;
        this.value = value;
    }
}

