/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.path;

import de.quantummaid.httpmaid.path.statemachine.StateMachineMatcher;
import de.quantummaid.httpmaid.util.Validators;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public final class RegexMatcher
implements StateMachineMatcher<String> {
    private static final Pattern PATTERN = Pattern.compile("\\|(.*)\\|");
    private static final Pattern NAMES_PATTERN = Pattern.compile("\\(\\?<([a-zA-Z][a-zA-Z0-9]*)>");
    private final Pattern regex;
    private final List<String> names;

    static boolean isRegex(String stringSpecification) {
        Matcher matcher = PATTERN.matcher(stringSpecification);
        return matcher.matches();
    }

    static StateMachineMatcher<String> fromStringSpecification(String stringSpecification) {
        Validators.validateNotNullNorEmpty(stringSpecification, "stringSpecification");
        Matcher matcher = PATTERN.matcher(stringSpecification);
        if (!matcher.matches()) {
            throw new RuntimeException("Not a regex: " + stringSpecification);
        }
        String regex = matcher.group(1);
        Matcher namesMatcher = NAMES_PATTERN.matcher(regex);
        LinkedList<String> names = new LinkedList<String>();
        while (namesMatcher.find()) {
            String group = namesMatcher.group(1);
            names.add(group);
        }
        Pattern regexPattern = Pattern.compile(regex);
        return new RegexMatcher(regexPattern, names);
    }

    @Override
    public Optional<Map<String, String>> matchAndReturnCaptures(String element) {
        Matcher matcher = this.regex.matcher(element);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        HashMap captures = new HashMap();
        this.names.forEach(name -> {
            try {
                String value = matcher.group((String)name);
                captures.put(name, value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        });
        return Optional.of(captures);
    }

    @Override
    public List<String> captures() {
        return Collections.unmodifiableList(this.names);
    }

    @Generated
    public String toString() {
        return "RegexMatcher(regex=" + this.regex + ", names=" + this.names + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegexMatcher)) {
            return false;
        }
        RegexMatcher other = (RegexMatcher)o;
        Pattern this$regex = this.regex;
        Pattern other$regex = other.regex;
        if (this$regex == null ? other$regex != null : !this$regex.equals(other$regex)) {
            return false;
        }
        List<String> this$names = this.names;
        List<String> other$names = other.names;
        return !(this$names == null ? other$names != null : !((Object)this$names).equals(other$names));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Pattern $regex = this.regex;
        result = result * 59 + ($regex == null ? 43 : $regex.hashCode());
        List<String> $names = this.names;
        result = result * 59 + ($names == null ? 43 : ((Object)$names).hashCode());
        return result;
    }

    @Generated
    private RegexMatcher(Pattern regex, List<String> names) {
        this.regex = regex;
        this.names = names;
    }
}

