/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.purejavaendpoint;

import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import de.quantummaid.httpmaid.HttpMaid;
import de.quantummaid.httpmaid.closing.ClosingActions;
import de.quantummaid.httpmaid.purejavaendpoint.PortStage;
import de.quantummaid.httpmaid.purejavaendpoint.PureJavaEndpointHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import lombok.Generated;

public final class PureJavaEndpoint
implements AutoCloseable {
    private final HttpMaid httpMaid;

    public static PortStage pureJavaEndpointFor(HttpMaid httpMaid) {
        return port -> {
            try {
                HttpServer httpServer = HttpServer.create(new InetSocketAddress(port), 0);
                HttpHandler httpHandler = PureJavaEndpointHandler.javaOnlyEndpointHandler(httpMaid);
                httpServer.createContext("/", httpHandler);
                httpServer.setExecutor(null);
                httpServer.start();
                httpMaid.getMetaDatum(ClosingActions.CLOSING_ACTIONS).addClosingAction(() -> httpServer.stop(0));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return new PureJavaEndpoint(httpMaid);
        };
    }

    @Override
    public void close() {
        this.httpMaid.close();
    }

    @Generated
    public String toString() {
        return "PureJavaEndpoint(httpMaid=" + this.httpMaid + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PureJavaEndpoint)) {
            return false;
        }
        PureJavaEndpoint other = (PureJavaEndpoint)o;
        HttpMaid this$httpMaid = this.httpMaid;
        HttpMaid other$httpMaid = other.httpMaid;
        return !(this$httpMaid == null ? other$httpMaid != null : !this$httpMaid.equals(other$httpMaid));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpMaid $httpMaid = this.httpMaid;
        result = result * 59 + ($httpMaid == null ? 43 : $httpMaid.hashCode());
        return result;
    }

    @Generated
    private PureJavaEndpoint(HttpMaid httpMaid) {
        this.httpMaid = httpMaid;
    }
}

