/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.security;

import de.quantummaid.httpmaid.chains.ChainExtender;
import de.quantummaid.httpmaid.chains.ChainModule;
import de.quantummaid.httpmaid.chains.ChainName;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.security.SecurityProcessor;
import de.quantummaid.httpmaid.util.Validators;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public final class SecurityModule
implements ChainModule {
    private final List<SecurityProcessor> securityProcessors = new LinkedList<SecurityProcessor>();

    public static ChainModule securityModule() {
        return new SecurityModule();
    }

    public void addSecurityProcessor(SecurityProcessor securityProcessor) {
        Validators.validateNotNull(securityProcessor, "securityProcessor");
        this.securityProcessors.add(securityProcessor);
    }

    private static <T extends Processor> void add(ChainName chainName, T element, Map<ChainName, List<T>> multiMap) {
        List forChain = multiMap.computeIfAbsent(chainName, x -> new LinkedList());
        forChain.add(element);
    }

    @Override
    public void register(ChainExtender extender) {
        this.securityProcessors.forEach(securityProcessor -> {
            ChainName chainName = securityProcessor.chainName();
            extender.appendProcessor(chainName, (Processor)securityProcessor);
        });
    }

    @Generated
    public String toString() {
        return "SecurityModule(securityProcessors=" + this.securityProcessors + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecurityModule)) {
            return false;
        }
        SecurityModule other = (SecurityModule)o;
        List<SecurityProcessor> this$securityProcessors = this.securityProcessors;
        List<SecurityProcessor> other$securityProcessors = other.securityProcessors;
        return !(this$securityProcessors == null ? other$securityProcessors != null : !((Object)this$securityProcessors).equals(other$securityProcessors));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<SecurityProcessor> $securityProcessors = this.securityProcessors;
        result = result * 59 + ($securityProcessors == null ? 43 : ((Object)$securityProcessors).hashCode());
        return result;
    }

    @Generated
    private SecurityModule() {
    }
}

