/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.util.describing;

import de.quantummaid.httpmaid.util.Validators;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;

final class EscapedText {
    private final List<String> lines;

    static EscapedText escapedText(String text) {
        Validators.validateNotNull(text, "text");
        List<String> list = EscapedText.escapeNewlines(text, line -> line);
        return new EscapedText(list);
    }

    int maxLineLength() {
        return this.lines.stream().mapToInt(String::length).max().getAsInt();
    }

    List<String> renderLines(int width) {
        LinkedList<String> renderedLines = new LinkedList<String>();
        this.lines.forEach(line -> {
            List<String> chunks = this.splitInChunks((String)line, width);
            renderedLines.addAll(chunks);
        });
        return renderedLines;
    }

    private List<String> splitInChunks(String string, int width) {
        LinkedList<String> chunks = new LinkedList<String>();
        int length = string.length();
        for (int i = 0; i < length; i += width) {
            String chunk = string.substring(i, Math.min(length, i + width));
            chunks.add(chunk);
        }
        return chunks;
    }

    private static List<String> escapeNewlines(String text, Function<String, String> operation) {
        String[] lines = text.split("\n");
        LinkedList<String> transformed = new LinkedList<String>();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            String transformedLine = i < lines.length - 1 ? operation.apply(line) : line;
            transformed.add(transformedLine);
        }
        return transformed;
    }

    @Generated
    public String toString() {
        return "EscapedText(lines=" + this.lines + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EscapedText)) {
            return false;
        }
        EscapedText other = (EscapedText)o;
        List<String> this$lines = this.lines;
        List<String> other$lines = other.lines;
        return !(this$lines == null ? other$lines != null : !((Object)this$lines).equals(other$lines));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $lines = this.lines;
        result = result * 59 + ($lines == null ? 43 : ((Object)$lines).hashCode());
        return result;
    }

    @Generated
    private EscapedText(List<String> lines) {
        this.lines = lines;
    }
}

