/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.cors;

import de.quantummaid.httpmaid.cors.CorsConfigurator;
import de.quantummaid.httpmaid.cors.domain.Origin;
import de.quantummaid.httpmaid.util.Validators;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public final class CorsConfigurators {
    private CorsConfigurators() {
    }

    public static CorsConfigurator toActivateCORSWithAllowedOrigins(String ... hostNames) {
        Validators.validateNotNull(hostNames, "hostNames");
        List allowedOrigins = Arrays.stream(hostNames).map(Origin::fromString).collect(Collectors.toList());
        return CorsConfigurator.corsConfigurator(allowedOrigins::contains);
    }

    public static CorsConfigurator toActivateCORSWithoutValidatingTheOrigin() {
        return CorsConfigurator.corsConfigurator(origin -> true);
    }
}

