/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.handler.distribution;

import de.quantummaid.httpmaid.generator.GenerationCondition;
import de.quantummaid.httpmaid.util.Validators;
import java.util.function.BiConsumer;
import java.util.function.Predicate;

public final class HandlerDistributor {
    private final Predicate<Object> predicate;
    private final BiConsumer<Object, GenerationCondition> handlerConsumer;

    public static HandlerDistributor handlerDistributor(Predicate<Object> predicate, BiConsumer<Object, GenerationCondition> handlerConsumer) {
        Validators.validateNotNull(predicate, "predicate");
        Validators.validateNotNull(handlerConsumer, "handlerConsumer");
        return new HandlerDistributor(predicate, handlerConsumer);
    }

    public boolean appliesTo(Object handler) {
        return this.predicate.test(handler);
    }

    public void consume(Object handler, GenerationCondition condition) {
        this.handlerConsumer.accept(handler, condition);
    }

    public String toString() {
        return "HandlerDistributor(predicate=" + this.predicate + ", handlerConsumer=" + this.handlerConsumer + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HandlerDistributor)) {
            return false;
        }
        HandlerDistributor other = (HandlerDistributor)o;
        Predicate<Object> this$predicate = this.predicate;
        Predicate<Object> other$predicate = other.predicate;
        if (this$predicate == null ? other$predicate != null : !this$predicate.equals(other$predicate)) {
            return false;
        }
        BiConsumer<Object, GenerationCondition> this$handlerConsumer = this.handlerConsumer;
        BiConsumer<Object, GenerationCondition> other$handlerConsumer = other.handlerConsumer;
        return !(this$handlerConsumer == null ? other$handlerConsumer != null : !this$handlerConsumer.equals(other$handlerConsumer));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Predicate<Object> $predicate = this.predicate;
        result = result * 59 + ($predicate == null ? 43 : $predicate.hashCode());
        BiConsumer<Object, GenerationCondition> $handlerConsumer = this.handlerConsumer;
        result = result * 59 + ($handlerConsumer == null ? 43 : $handlerConsumer.hashCode());
        return result;
    }

    private HandlerDistributor(Predicate<Object> predicate, BiConsumer<Object, GenerationCondition> handlerConsumer) {
        this.predicate = predicate;
        this.handlerConsumer = handlerConsumer;
    }
}

