/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.security.authorization;

import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.security.authorization.Authorizer;
import de.quantummaid.httpmaid.security.authorization.AuthorizerId;
import de.quantummaid.httpmaid.security.authorization.NotAuthorizedException;

public final class AuthorizerProcessor
implements Processor {
    private final Authorizer authorizer;
    private final AuthorizerId authorizerId;

    public static AuthorizerProcessor authorizerProcessor(Authorizer authorizer, AuthorizerId authorizerId) {
        return new AuthorizerProcessor(authorizer, authorizerId);
    }

    @Override
    public void apply(MetaData metaData) {
        if (!this.authorizer.isAuthorized(metaData)) {
            throw NotAuthorizedException.notAuthorizedException(metaData, this.authorizerId);
        }
    }

    public String toString() {
        return "AuthorizerProcessor(authorizer=" + this.authorizer + ", authorizerId=" + this.authorizerId + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthorizerProcessor)) {
            return false;
        }
        AuthorizerProcessor other = (AuthorizerProcessor)o;
        Authorizer this$authorizer = this.authorizer;
        Authorizer other$authorizer = other.authorizer;
        if (this$authorizer == null ? other$authorizer != null : !this$authorizer.equals(other$authorizer)) {
            return false;
        }
        AuthorizerId this$authorizerId = this.authorizerId;
        AuthorizerId other$authorizerId = other.authorizerId;
        return !(this$authorizerId == null ? other$authorizerId != null : !((Object)this$authorizerId).equals(other$authorizerId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Authorizer $authorizer = this.authorizer;
        result = result * 59 + ($authorizer == null ? 43 : $authorizer.hashCode());
        AuthorizerId $authorizerId = this.authorizerId;
        result = result * 59 + ($authorizerId == null ? 43 : ((Object)$authorizerId).hashCode());
        return result;
    }

    private AuthorizerProcessor(Authorizer authorizer, AuthorizerId authorizerId) {
        this.authorizer = authorizer;
        this.authorizerId = authorizerId;
    }
}

