/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid;

import de.quantummaid.httpmaid.HttpMaidBuilder;
import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.HttpMaidChains;
import de.quantummaid.httpmaid.chains.ChainName;
import de.quantummaid.httpmaid.chains.ChainRegistry;
import de.quantummaid.httpmaid.chains.FinalConsumer;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.MetaDataKey;
import de.quantummaid.httpmaid.closing.ClosingActions;
import de.quantummaid.httpmaid.endpoint.RawRequest;
import de.quantummaid.httpmaid.endpoint.RawRequestExtractor;
import de.quantummaid.httpmaid.endpoint.RawResponse;
import de.quantummaid.httpmaid.endpoint.RawResponseFactory;
import de.quantummaid.httpmaid.endpoint.RawResponseHandler;
import de.quantummaid.httpmaid.endpoint.SynchronizationWrapper;
import de.quantummaid.httpmaid.logger.Logger;
import de.quantummaid.httpmaid.util.Validators;
import java.io.IOException;
import java.time.Duration;
import java.util.Optional;
import lombok.Generated;

public final class HttpMaid
implements AutoCloseable {
    public static final MetaDataKey<Duration> STARTUP_TIME = MetaDataKey.metaDataKey("STARTUP_TIME");
    private final ChainRegistry chainRegistry;

    public static HttpMaid httpMaid(ChainRegistry chainRegistry) {
        Validators.validateNotNull(chainRegistry, "chainRegistry");
        return new HttpMaid(chainRegistry);
    }

    public void handle(ChainName chainName, MetaData metaData) {
        this.chainRegistry.putIntoChain(chainName, metaData, metaData1 -> {});
    }

    public <T> T handleRequestSynchronously(RawRequestExtractor rawRequestExtractor, RawResponseFactory<T> rawResponseFactory) {
        SynchronizationWrapper synchronizationWrapper = SynchronizationWrapper.synchronizationWrapper();
        this.handleRequest(rawRequestExtractor, (RawResponse response) -> {
            Object returnedResponse = rawResponseFactory.createResponse(response);
            synchronizationWrapper.setObject(returnedResponse);
        });
        return synchronizationWrapper.getObject();
    }

    public void handleRequest(RawRequestExtractor rawRequestExtractor, RawResponseHandler rawResponseHandler) {
        RawRequest rawRequest;
        try {
            rawRequest = rawRequestExtractor.extract();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        MetaData metaData = MetaData.emptyMetaData();
        rawRequest.enter(metaData);
        this.chainRegistry.putIntoChain(HttpMaidChains.INIT, metaData, finalMetaData -> {
            RawResponse rawResponse = RawResponse.rawResponse(finalMetaData);
            try {
                rawResponseHandler.handle(rawResponse);
            }
            catch (Exception e) {
                Logger logger = finalMetaData.get(HttpMaidChainKeys.LOGGER);
                logger.error(e);
            }
        });
    }

    public void handleRequest(MetaData metaData, FinalConsumer responseHandler) {
        this.chainRegistry.putIntoChain(HttpMaidChains.INIT, metaData, finalMetaData -> {
            try {
                responseHandler.consume(metaData);
            }
            catch (IOException e) {
                Logger logger = finalMetaData.get(HttpMaidChainKeys.LOGGER);
                logger.error(e);
            }
        });
    }

    public <T> T getMetaDatum(MetaDataKey<T> key) {
        Validators.validateNotNull(key, "key");
        return this.chainRegistry.getMetaDatum(key);
    }

    public <T> Optional<T> getOptionalMetaDatum(MetaDataKey<T> key) {
        Validators.validateNotNull(key, "key");
        return this.chainRegistry.getOptionalMetaDatum(key);
    }

    public String dumpChains() {
        return this.chainRegistry.dump();
    }

    public static HttpMaidBuilder anHttpMaid() {
        return HttpMaidBuilder.httpMaidBuilder();
    }

    @Override
    public void close() {
        ClosingActions closingActions = this.chainRegistry.getMetaDatum(ClosingActions.CLOSING_ACTIONS);
        closingActions.closeAll();
    }

    @Generated
    private HttpMaid(ChainRegistry chainRegistry) {
        this.chainRegistry = chainRegistry;
    }
}

