/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.chains;

import de.quantummaid.httpmaid.chains.ChainModule;
import de.quantummaid.httpmaid.util.Validators;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;

final class IndexedModules {
    private final List<ChainModule> modules;

    static IndexedModules indexedModules(List<ChainModule> initialModules) {
        Validators.validateNotNull(initialModules, "initialModules");
        return new IndexedModules(new LinkedList<ChainModule>(initialModules));
    }

    <T extends ChainModule> T get(Class<T> type) {
        return (T)((ChainModule)this.find(type).orElseThrow(() -> new RuntimeException(String.format("Module of type '%s' not found", type.getSimpleName()))));
    }

    public boolean contains(Class<? extends ChainModule> type) {
        return this.find(type).isPresent();
    }

    public void add(ChainModule module) {
        Validators.validateNotNull(module, "module");
        this.modules.add(module);
    }

    public Stream<? extends ChainModule> stream() {
        return this.modules.stream();
    }

    private <T extends ChainModule> Optional<T> find(Class<T> type) {
        Validators.validateNotNull(type, "type");
        for (ChainModule module : this.modules) {
            if (!type.isInstance(module)) continue;
            return Optional.of(module);
        }
        return Optional.empty();
    }

    @Generated
    public String toString() {
        return "IndexedModules(modules=" + this.modules + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexedModules)) {
            return false;
        }
        IndexedModules other = (IndexedModules)o;
        List<ChainModule> this$modules = this.modules;
        List<ChainModule> other$modules = other.modules;
        return !(this$modules == null ? other$modules != null : !((Object)this$modules).equals(other$modules));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ChainModule> $modules = this.modules;
        result = result * 59 + ($modules == null ? 43 : ((Object)$modules).hashCode());
        return result;
    }

    @Generated
    private IndexedModules(List<ChainModule> modules) {
        this.modules = modules;
    }
}

