/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.security.basicauth;

import de.quantummaid.httpmaid.chains.ChainName;
import de.quantummaid.httpmaid.chains.DependencyRegistry;
import de.quantummaid.httpmaid.handler.http.HttpRequest;
import de.quantummaid.httpmaid.security.Filter;
import de.quantummaid.httpmaid.security.authentication.AuthenticatorConfigurator;
import de.quantummaid.httpmaid.security.basicauth.BasicAuthAuthenticator;
import de.quantummaid.httpmaid.security.config.SecurityConfigurator;
import de.quantummaid.httpmaid.util.Validators;
import java.util.Objects;
import lombok.Generated;

public final class BasicAuthConfigurator
implements SecurityConfigurator<BasicAuthConfigurator> {
    private final AuthenticatorConfigurator authenticatorConfigurator;
    private volatile String realm;

    public static BasicAuthConfigurator basicAuthenticationConfigurator(BasicAuthAuthenticator authenticator) {
        AuthenticatorConfigurator authenticatorConfigurator = AuthenticatorConfigurator.authenticatorConfigurator(metaData -> {
            HttpRequest request = HttpRequest.httpRequest(metaData);
            return authenticator.authenticate(request);
        });
        return new BasicAuthConfigurator(authenticatorConfigurator);
    }

    @Override
    public BasicAuthConfigurator inPhase(ChainName phase) {
        this.authenticatorConfigurator.inPhase(phase);
        return this;
    }

    @Override
    public BasicAuthConfigurator onlyRequestsThat(Filter filter) {
        this.authenticatorConfigurator.onlyRequestsThat(filter);
        return this;
    }

    public BasicAuthConfigurator withMessage(String message) {
        Validators.validateNotNull(message, "message");
        this.realm = message;
        return this;
    }

    @Override
    public void configure(DependencyRegistry dependencyRegistry) {
        this.authenticatorConfigurator.rejectingUnauthenticatedRequestsUsing((request, response) -> {
            StringBuilder headerBuilder = new StringBuilder();
            headerBuilder.append("Basic");
            if (Objects.nonNull(this.realm)) {
                headerBuilder.append(String.format(" realm=\"%s\"", this.realm));
            }
            response.addHeader("WWW-Authenticate", headerBuilder.toString());
            response.setStatus(401);
        });
        this.authenticatorConfigurator.configure(dependencyRegistry);
    }

    @Generated
    public String toString() {
        return "BasicAuthConfigurator(authenticatorConfigurator=" + this.authenticatorConfigurator + ", realm=" + this.realm + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasicAuthConfigurator)) {
            return false;
        }
        BasicAuthConfigurator other = (BasicAuthConfigurator)o;
        AuthenticatorConfigurator this$authenticatorConfigurator = this.authenticatorConfigurator;
        AuthenticatorConfigurator other$authenticatorConfigurator = other.authenticatorConfigurator;
        if (this$authenticatorConfigurator == null ? other$authenticatorConfigurator != null : !((Object)this$authenticatorConfigurator).equals(other$authenticatorConfigurator)) {
            return false;
        }
        String this$realm = this.realm;
        String other$realm = other.realm;
        return !(this$realm == null ? other$realm != null : !this$realm.equals(other$realm));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AuthenticatorConfigurator $authenticatorConfigurator = this.authenticatorConfigurator;
        result = result * 59 + ($authenticatorConfigurator == null ? 43 : ((Object)$authenticatorConfigurator).hashCode());
        String $realm = this.realm;
        result = result * 59 + ($realm == null ? 43 : $realm.hashCode());
        return result;
    }

    @Generated
    private BasicAuthConfigurator(AuthenticatorConfigurator authenticatorConfigurator) {
        this.authenticatorConfigurator = authenticatorConfigurator;
    }
}

