/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.cors;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.cors.domain.Origin;
import de.quantummaid.httpmaid.cors.policy.ResourceSharingPolicy;
import de.quantummaid.httpmaid.util.Validators;
import java.util.Map;
import lombok.Generated;

public final class SimpleCrossOriginRequestProcessor
implements Processor {
    private final ResourceSharingPolicy resourceSharingPolicy;

    public static Processor simpleCrossOriginRequestProcessor(ResourceSharingPolicy resourceSharingPolicy) {
        Validators.validateNotNull(resourceSharingPolicy, "resourceSharingPolicy");
        return new SimpleCrossOriginRequestProcessor(resourceSharingPolicy);
    }

    @Override
    public void apply(MetaData metaData) {
        Origin.load(metaData).ifPresent(origin -> {
            if (!this.resourceSharingPolicy.validateOrigin((Origin)origin)) {
                return;
            }
            Map<String, String> responseHeaders = metaData.get(HttpMaidChainKeys.RESPONSE_HEADERS);
            responseHeaders.put("Access-Control-Allow-Origin", origin.internalValueForMapping());
            if (this.resourceSharingPolicy.supportsCredentials()) {
                responseHeaders.put("Access-Control-Allow-Credentials", "true");
            }
            this.resourceSharingPolicy.exposedHeaders().generateHeaderValue().ifPresent(value -> responseHeaders.put("Access-Control-Expose-Headers", (String)value));
        });
    }

    @Generated
    public String toString() {
        return "SimpleCrossOriginRequestProcessor(resourceSharingPolicy=" + this.resourceSharingPolicy + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleCrossOriginRequestProcessor)) {
            return false;
        }
        SimpleCrossOriginRequestProcessor other = (SimpleCrossOriginRequestProcessor)o;
        ResourceSharingPolicy this$resourceSharingPolicy = this.resourceSharingPolicy;
        ResourceSharingPolicy other$resourceSharingPolicy = other.resourceSharingPolicy;
        return !(this$resourceSharingPolicy == null ? other$resourceSharingPolicy != null : !((Object)this$resourceSharingPolicy).equals(other$resourceSharingPolicy));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResourceSharingPolicy $resourceSharingPolicy = this.resourceSharingPolicy;
        result = result * 59 + ($resourceSharingPolicy == null ? 43 : ((Object)$resourceSharingPolicy).hashCode());
        return result;
    }

    @Generated
    private SimpleCrossOriginRequestProcessor(ResourceSharingPolicy resourceSharingPolicy) {
        this.resourceSharingPolicy = resourceSharingPolicy;
    }
}

