/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.cors.domain;

import de.quantummaid.httpmaid.cors.domain.ExposedHeader;
import de.quantummaid.httpmaid.util.Validators;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public final class ExposedHeaders {
    private final List<ExposedHeader> exposedHeaders;

    public static ExposedHeaders exposedHeaders(List<ExposedHeader> exposedHeaders) {
        Validators.validateNotNull(exposedHeaders, "exposedHeaders");
        return new ExposedHeaders(exposedHeaders);
    }

    public Optional<String> generateHeaderValue() {
        if (this.exposedHeaders.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.exposedHeaders.stream().filter(exposedHeader -> !exposedHeader.isSimpleHeader()).map(ExposedHeader::internalValueForMapping).collect(Collectors.joining(",")));
    }

    @Generated
    public String toString() {
        return "ExposedHeaders(exposedHeaders=" + this.exposedHeaders + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExposedHeaders)) {
            return false;
        }
        ExposedHeaders other = (ExposedHeaders)o;
        List<ExposedHeader> this$exposedHeaders = this.exposedHeaders;
        List<ExposedHeader> other$exposedHeaders = other.exposedHeaders;
        return !(this$exposedHeaders == null ? other$exposedHeaders != null : !((Object)this$exposedHeaders).equals(other$exposedHeaders));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ExposedHeader> $exposedHeaders = this.exposedHeaders;
        result = result * 59 + ($exposedHeaders == null ? 43 : ((Object)$exposedHeaders).hashCode());
        return result;
    }

    @Generated
    private ExposedHeaders(List<ExposedHeader> exposedHeaders) {
        this.exposedHeaders = exposedHeaders;
    }
}

