/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.endpoint.purejavaendpoint;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import de.quantummaid.httpmaid.HttpMaid;
import de.quantummaid.httpmaid.endpoint.RawRequest;
import de.quantummaid.httpmaid.endpoint.RawRequestBuilder;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import lombok.Generated;

final class PureJavaEndpointHandler
implements HttpHandler {
    private final HttpMaid httpMaid;

    static HttpHandler javaOnlyEndpointHandler(HttpMaid httpMaid) {
        return new PureJavaEndpointHandler(httpMaid);
    }

    @Override
    public void handle(HttpExchange httpExchange) {
        this.httpMaid.handleRequest(() -> {
            RawRequestBuilder builder = RawRequest.rawRequestBuilder();
            URI requestURI = httpExchange.getRequestURI();
            builder.withUri(requestURI);
            String requestMethod = httpExchange.getRequestMethod();
            builder.withMethod(requestMethod);
            Headers requestHeaders = httpExchange.getRequestHeaders();
            builder.withHeaders(requestHeaders);
            InputStream requestBody = httpExchange.getRequestBody();
            builder.withBody(requestBody);
            return builder.build();
        }, response -> {
            Headers responseHeaders = httpExchange.getResponseHeaders();
            response.headers().forEach(responseHeaders::put);
            httpExchange.sendResponseHeaders(response.status(), 0L);
            OutputStream outputStream = httpExchange.getResponseBody();
            response.streamBodyToOutputStream(outputStream);
        });
    }

    @Generated
    private PureJavaEndpointHandler(HttpMaid httpMaid) {
        this.httpMaid = httpMaid;
    }
}

