/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.handler.http;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.handler.http.files.FileLoader;
import de.quantummaid.httpmaid.handler.http.files.MultiformatPath;
import de.quantummaid.httpmaid.http.headers.ContentType;
import de.quantummaid.httpmaid.http.headers.cookies.CookieBuilder;
import de.quantummaid.httpmaid.path.Path;
import de.quantummaid.httpmaid.util.Validators;
import java.io.File;
import java.io.InputStream;
import java.time.Instant;
import java.util.Map;
import lombok.Generated;

public final class HttpResponse {
    private final MetaData metaData;

    public static HttpResponse httpResponse(MetaData metaData) {
        Validators.validateNotNull(metaData, "metaData");
        return new HttpResponse(metaData);
    }

    public void addHeader(String key, String value) {
        this.metaData.get(HttpMaidChainKeys.RESPONSE_HEADERS).put(key, value);
    }

    public void setCookie(CookieBuilder cookie) {
        Validators.validateNotNull(cookie, "cookie");
        this.addHeader("Set-Cookie", cookie.build());
    }

    public void setCookie(String name, String value) {
        this.setCookie(CookieBuilder.cookie(name, value));
    }

    public void invalidateCookie(String name) {
        this.setCookie(CookieBuilder.cookie(name, "").withExpiration(Instant.EPOCH));
    }

    public void setContentType(String contentType) {
        this.setContentType(ContentType.fromString(contentType));
    }

    public void setContentType(ContentType contentType) {
        Validators.validateNotNull(contentType, "contentType");
        this.addHeader("Content-Type", contentType.valueWithComment());
    }

    public void asDownloadWithFilename(String filename) {
        Validators.validateNotNull(filename, "filename");
        String contentDispositionHeader = String.format("attachment; filename=\"%s\"", filename);
        this.addHeader("Content-Disposition", contentDispositionHeader);
        this.setContentType("application/x-msdownload");
    }

    public void redirectTo(String target) {
        Validators.validateNotNull(target, "target");
        this.setStatus(302);
        this.addHeader("Location", target);
    }

    public void setStatus(int status) {
        this.metaData.set(HttpMaidChainKeys.RESPONSE_STATUS, status);
    }

    public void setBody(Map<String, Object> map) {
        this.metaData.set(HttpMaidChainKeys.RESPONSE_BODY_OBJECT, map);
    }

    public void setBody(String body) {
        Validators.validateNotNull(body, "body");
        this.metaData.set(HttpMaidChainKeys.RESPONSE_BODY_STRING, body);
    }

    public void setBody(InputStream inputStream) {
        Validators.validateNotNull(inputStream, "inputStream");
        this.metaData.set(HttpMaidChainKeys.RESPONSE_STREAM, inputStream);
    }

    public void setFileAsBody(String path) {
        Validators.validateNotNullNorEmpty(path, "path");
        File file = new File(path);
        this.setFileAsBody(file);
    }

    public void setFileAsBody(File file) {
        Validators.validateNotNull(file, "file");
        InputStream stream = FileLoader.loadFile(file);
        this.setBody(stream);
    }

    public void setJavaResourceAsBody(String path) {
        Validators.validateNotNullNorEmpty(path, "path");
        MultiformatPath multiformatPath = MultiformatPath.multiformatPath(path);
        InputStream stream = FileLoader.loadJavaResource(multiformatPath);
        this.setBody(stream);
    }

    public void mapPathToFileInDirectory(String directory) {
        this.mapPathToFileInDirectory(directory, "");
    }

    public void mapPathToFileInDirectory(String directory, String pathPrefix) {
        String filePath = this.rebasedRequestPath(directory, pathPrefix);
        this.setFileAsBody(filePath);
    }

    public void mapPathToJavaResourceInDirectory(String directory) {
        this.mapPathToJavaResourceInDirectory(directory, "");
    }

    public void mapPathToJavaResourceInDirectory(String directory, String pathPrefix) {
        String absolutePath = this.rebasedRequestPath(directory, pathPrefix);
        this.setJavaResourceAsBody(absolutePath);
    }

    private String rebasedRequestPath(String directory, String prefix) {
        Path requestPath = this.metaData.get(HttpMaidChainKeys.PATH);
        Path rebasedPath = requestPath.cutPrefix(prefix).safelyRebaseTo(directory);
        return rebasedPath.raw();
    }

    @Generated
    public String toString() {
        return "HttpResponse(metaData=" + this.metaData + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpResponse)) {
            return false;
        }
        HttpResponse other = (HttpResponse)o;
        MetaData this$metaData = this.metaData;
        MetaData other$metaData = other.metaData;
        return !(this$metaData == null ? other$metaData != null : !((Object)this$metaData).equals(other$metaData));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MetaData $metaData = this.metaData;
        result = result * 59 + ($metaData == null ? 43 : ((Object)$metaData).hashCode());
        return result;
    }

    @Generated
    private HttpResponse(MetaData metaData) {
        this.metaData = metaData;
    }
}

