/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.http;

import de.quantummaid.httpmaid.http.HeaderKey;
import de.quantummaid.httpmaid.http.HeaderValue;
import de.quantummaid.httpmaid.util.Maps;
import de.quantummaid.httpmaid.util.Validators;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public final class Headers {
    private final Map<HeaderKey, HeaderValue> headers;

    public static Headers headers(Map<String, List<String>> stringMap) {
        Validators.validateNotNull(stringMap, "stringMap");
        Map<HeaderKey, HeaderValue> headers = Maps.transformMap(stringMap, HeaderKey::headerKey, HeaderValue::headerValue);
        return new Headers(headers);
    }

    public Optional<String> getOptionalHeader(String key) {
        HeaderKey headerKey = HeaderKey.headerKey(key);
        return Maps.getOptionally(this.headers, headerKey).map(HeaderValue::stringValue);
    }

    public String getHeader(String key) {
        return this.getOptionalHeader(key).orElseThrow(() -> new IllegalArgumentException(String.format("No header with name %s", key)));
    }

    public Map<String, String> asStringMap() {
        return Maps.valueObjectsToStrings(this.headers, HeaderKey::stringValue, HeaderValue::stringValue);
    }

    @Generated
    public String toString() {
        return "Headers(headers=" + this.headers + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Headers)) {
            return false;
        }
        Headers other = (Headers)o;
        Map<HeaderKey, HeaderValue> this$headers = this.headers;
        Map<HeaderKey, HeaderValue> other$headers = other.headers;
        return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<HeaderKey, HeaderValue> $headers = this.headers;
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        return result;
    }

    @Generated
    private Headers(Map<HeaderKey, HeaderValue> headers) {
        this.headers = headers;
    }
}

