/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.security.authorization;

import de.quantummaid.httpmaid.CoreModule;
import de.quantummaid.httpmaid.chains.ChainName;
import de.quantummaid.httpmaid.chains.DependencyRegistry;
import de.quantummaid.httpmaid.handler.http.HttpHandler;
import de.quantummaid.httpmaid.security.Filter;
import de.quantummaid.httpmaid.security.SimpleSecurityConfigurator;
import de.quantummaid.httpmaid.security.authorization.AuthorizerId;
import de.quantummaid.httpmaid.security.authorization.AuthorizerProcessor;
import de.quantummaid.httpmaid.security.authorization.HttpAuthorizer;
import de.quantummaid.httpmaid.security.authorization.NotAuthorizedException;
import de.quantummaid.httpmaid.security.config.SecurityConfigurator;
import de.quantummaid.httpmaid.util.Validators;
import java.util.Objects;
import lombok.Generated;

public class AuthorizerConfigurator
implements SecurityConfigurator<AuthorizerConfigurator> {
    private final SimpleSecurityConfigurator simpleSecurityConfigurator;
    private final AuthorizerId authorizerId;
    private HttpHandler rejectionHandler;

    public static AuthorizerConfigurator authorizerConfigurator(HttpAuthorizer authorizer) {
        Validators.validateNotNull(authorizer, "authorizer");
        AuthorizerId authorizerId = AuthorizerId.uniqueAuthorizerId();
        AuthorizerProcessor processor = AuthorizerProcessor.authorizerProcessor(authorizer, authorizerId);
        SimpleSecurityConfigurator simpleSecurityConfigurator = SimpleSecurityConfigurator.simpleSecurityConfigurator(processor);
        return new AuthorizerConfigurator(simpleSecurityConfigurator, authorizerId);
    }

    @Override
    public AuthorizerConfigurator inPhase(ChainName phase) {
        this.simpleSecurityConfigurator.inPhase(phase);
        return this;
    }

    @Override
    public AuthorizerConfigurator onlyRequestsThat(Filter filter) {
        this.simpleSecurityConfigurator.onlyRequestsThat(filter);
        return this;
    }

    public AuthorizerConfigurator rejectingUnauthorizedRequestsUsing(HttpHandler rejectionHandler) {
        Validators.validateNotNull(rejectionHandler, "rejectionHandler");
        this.rejectionHandler = rejectionHandler;
        return this;
    }

    @Override
    public void configure(DependencyRegistry dependencyRegistry) {
        this.simpleSecurityConfigurator.configure(dependencyRegistry);
        if (Objects.nonNull(this.rejectionHandler)) {
            CoreModule coreModule = dependencyRegistry.getDependency(CoreModule.class);
            coreModule.addExceptionMapper(throwable -> {
                if (!(throwable instanceof NotAuthorizedException)) {
                    return false;
                }
                return ((NotAuthorizedException)throwable).authorizerId().equals(this.authorizerId);
            }, (exception, metaData) -> this.rejectionHandler.handle(metaData));
        }
    }

    @Generated
    public String toString() {
        return "AuthorizerConfigurator(simpleSecurityConfigurator=" + this.simpleSecurityConfigurator + ", authorizerId=" + this.authorizerId + ", rejectionHandler=" + this.rejectionHandler + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthorizerConfigurator)) {
            return false;
        }
        AuthorizerConfigurator other = (AuthorizerConfigurator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SimpleSecurityConfigurator this$simpleSecurityConfigurator = this.simpleSecurityConfigurator;
        SimpleSecurityConfigurator other$simpleSecurityConfigurator = other.simpleSecurityConfigurator;
        if (this$simpleSecurityConfigurator == null ? other$simpleSecurityConfigurator != null : !((Object)this$simpleSecurityConfigurator).equals(other$simpleSecurityConfigurator)) {
            return false;
        }
        AuthorizerId this$authorizerId = this.authorizerId;
        AuthorizerId other$authorizerId = other.authorizerId;
        if (this$authorizerId == null ? other$authorizerId != null : !((Object)this$authorizerId).equals(other$authorizerId)) {
            return false;
        }
        HttpHandler this$rejectionHandler = this.rejectionHandler;
        HttpHandler other$rejectionHandler = other.rejectionHandler;
        return !(this$rejectionHandler == null ? other$rejectionHandler != null : !this$rejectionHandler.equals(other$rejectionHandler));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AuthorizerConfigurator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SimpleSecurityConfigurator $simpleSecurityConfigurator = this.simpleSecurityConfigurator;
        result = result * 59 + ($simpleSecurityConfigurator == null ? 43 : ((Object)$simpleSecurityConfigurator).hashCode());
        AuthorizerId $authorizerId = this.authorizerId;
        result = result * 59 + ($authorizerId == null ? 43 : ((Object)$authorizerId).hashCode());
        HttpHandler $rejectionHandler = this.rejectionHandler;
        result = result * 59 + ($rejectionHandler == null ? 43 : $rejectionHandler.hashCode());
        return result;
    }

    @Generated
    private AuthorizerConfigurator(SimpleSecurityConfigurator simpleSecurityConfigurator, AuthorizerId authorizerId) {
        this.simpleSecurityConfigurator = simpleSecurityConfigurator;
        this.authorizerId = authorizerId;
    }
}

