/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.endpoint;

import de.quantummaid.httpmaid.chains.MetaDataKey;
import de.quantummaid.httpmaid.endpoint.RawRequest;
import de.quantummaid.httpmaid.util.Maps;
import de.quantummaid.httpmaid.util.streams.Streams;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public final class RawRequestBuilder {
    private String path;
    private String requestMethod;
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private Map<String, String> queryParameters = new HashMap<String, String>();
    private InputStream body;
    private final Map<MetaDataKey<?>, Object> additionalMetaData = new HashMap();

    public static RawRequestBuilder rawRequestBuilder() {
        return new RawRequestBuilder();
    }

    public RawRequestBuilder withUri(URI uri) {
        this.withPath(uri.getPath());
        this.withEncodedQueryParameters(uri.getQuery());
        return this;
    }

    public RawRequestBuilder withPath(String path) {
        this.path = path;
        return this;
    }

    public RawRequestBuilder withMethod(String method) {
        this.requestMethod = method;
        return this;
    }

    public RawRequestBuilder withUniqueHeaders(Map<String, String> headers) {
        Map<String, List<String>> multiMap = Maps.mapToMultiMap(headers);
        return this.withHeaders(multiMap);
    }

    public RawRequestBuilder withHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
        return this;
    }

    public RawRequestBuilder withEncodedQueryParameters(String encodedQueryParameters) {
        Map<String, String> queryParametersMap = RawRequestBuilder.queryToMap(encodedQueryParameters);
        return this.withQueryParameters(queryParametersMap);
    }

    public RawRequestBuilder withQueryParameters(Map<String, String> queryParameters) {
        this.queryParameters = queryParameters;
        return this;
    }

    public RawRequestBuilder withBody(String body) {
        InputStream stream = Streams.stringToInputStream(body);
        return this.withBody(stream);
    }

    public RawRequestBuilder withBody(InputStream body) {
        this.body = body;
        return this;
    }

    public <T> RawRequestBuilder withAdditionalMetaData(MetaDataKey<T> key, T value) {
        this.additionalMetaData.put(key, value);
        return this;
    }

    public RawRequest build() {
        if (this.body == null) {
            this.withBody("");
        }
        return RawRequest.rawRequest(this.path, this.requestMethod, this.headers, this.queryParameters, this.body, this.additionalMetaData);
    }

    private static Map<String, String> queryToMap(String query) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (query == null) {
            return result;
        }
        for (String param : query.split("&")) {
            String[] entry = param.split("=");
            if (entry.length > 1) {
                result.put(entry[0], entry[1]);
                continue;
            }
            result.put(entry[0], "");
        }
        return result;
    }

    @Generated
    public String toString() {
        return "RawRequestBuilder(path=" + this.path + ", requestMethod=" + this.requestMethod + ", headers=" + this.headers + ", queryParameters=" + this.queryParameters + ", body=" + this.body + ", additionalMetaData=" + this.additionalMetaData + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawRequestBuilder)) {
            return false;
        }
        RawRequestBuilder other = (RawRequestBuilder)o;
        String this$path = this.path;
        String other$path = other.path;
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$requestMethod = this.requestMethod;
        String other$requestMethod = other.requestMethod;
        if (this$requestMethod == null ? other$requestMethod != null : !this$requestMethod.equals(other$requestMethod)) {
            return false;
        }
        Map<String, List<String>> this$headers = this.headers;
        Map<String, List<String>> other$headers = other.headers;
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        Map<String, String> this$queryParameters = this.queryParameters;
        Map<String, String> other$queryParameters = other.queryParameters;
        if (this$queryParameters == null ? other$queryParameters != null : !((Object)this$queryParameters).equals(other$queryParameters)) {
            return false;
        }
        InputStream this$body = this.body;
        InputStream other$body = other.body;
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        Map<MetaDataKey<?>, Object> this$additionalMetaData = this.additionalMetaData;
        Map<MetaDataKey<?>, Object> other$additionalMetaData = other.additionalMetaData;
        return !(this$additionalMetaData == null ? other$additionalMetaData != null : !((Object)this$additionalMetaData).equals(other$additionalMetaData));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $path = this.path;
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $requestMethod = this.requestMethod;
        result = result * 59 + ($requestMethod == null ? 43 : $requestMethod.hashCode());
        Map<String, List<String>> $headers = this.headers;
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        Map<String, String> $queryParameters = this.queryParameters;
        result = result * 59 + ($queryParameters == null ? 43 : ((Object)$queryParameters).hashCode());
        InputStream $body = this.body;
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        Map<MetaDataKey<?>, Object> $additionalMetaData = this.additionalMetaData;
        result = result * 59 + ($additionalMetaData == null ? 43 : ((Object)$additionalMetaData).hashCode());
        return result;
    }

    @Generated
    private RawRequestBuilder() {
    }
}

