/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.security.authentication;

import de.quantummaid.httpmaid.CoreModule;
import de.quantummaid.httpmaid.chains.ChainName;
import de.quantummaid.httpmaid.chains.DependencyRegistry;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.handler.http.HttpHandler;
import de.quantummaid.httpmaid.security.Filter;
import de.quantummaid.httpmaid.security.SimpleSecurityConfigurator;
import de.quantummaid.httpmaid.security.authentication.Authenticator;
import de.quantummaid.httpmaid.security.authentication.AuthenticatorId;
import de.quantummaid.httpmaid.security.authentication.AuthenticatorProcessor;
import de.quantummaid.httpmaid.security.authentication.CouldNotAuthenticateException;
import de.quantummaid.httpmaid.security.config.SecurityConfigurator;
import de.quantummaid.httpmaid.util.Validators;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public final class AuthenticatorConfigurator
implements SecurityConfigurator<AuthenticatorConfigurator> {
    private final SimpleSecurityConfigurator simpleSecurityConfigurator;
    private final AuthenticatorId authenticatorId;
    private final List<Filter> optionalRequests;
    private HttpHandler rejectionHandler;

    public static AuthenticatorConfigurator authenticatorConfigurator(Authenticator<MetaData> authenticator) {
        Validators.validateNotNull(authenticator, "authenticator");
        AuthenticatorId authenticatorId = AuthenticatorId.uniqueAuthenticatorId();
        LinkedList<Filter> optionalRequests = new LinkedList<Filter>();
        AuthenticatorProcessor processor = AuthenticatorProcessor.authenticatorProcessor(authenticator, authenticatorId, optionalRequests);
        SimpleSecurityConfigurator simpleSecurityConfigurator = SimpleSecurityConfigurator.simpleSecurityConfigurator(processor);
        return new AuthenticatorConfigurator(simpleSecurityConfigurator, authenticatorId, optionalRequests);
    }

    @Override
    public AuthenticatorConfigurator inPhase(ChainName phase) {
        this.simpleSecurityConfigurator.inPhase(phase);
        return this;
    }

    @Override
    public AuthenticatorConfigurator onlyRequestsThat(Filter filter) {
        this.simpleSecurityConfigurator.onlyRequestsThat(filter);
        return this;
    }

    public AuthenticatorConfigurator notFailingOnMissingAuthentication() {
        return this.notFailingOnMissingAuthenticationForRequestsThat(request -> true);
    }

    public AuthenticatorConfigurator notFailingOnMissingAuthenticationForRequestsThat(Filter filter) {
        Validators.validateNotNull(filter, "filter");
        this.optionalRequests.add(filter);
        return this;
    }

    public AuthenticatorConfigurator notFailingOnMissingAuthenticationForRequestsTo(String ... paths) {
        return this.notFailingOnMissingAuthenticationForRequestsThat(Filter.pathsFilter(paths));
    }

    public AuthenticatorConfigurator failingOnMissingAuthenticationOnlyForRequestsThat(Filter filter) {
        Validators.validateNotNull(filter, "filter");
        return this.notFailingOnMissingAuthenticationForRequestsThat(request -> !filter.filter(request));
    }

    public AuthenticatorConfigurator failingOnMissingAuthenticationOnlyForRequestsTo(String ... paths) {
        return this.notFailingOnMissingAuthenticationForRequestsThat(Filter.pathsFilter(paths));
    }

    public AuthenticatorConfigurator rejectingUnauthenticatedRequestsUsing(HttpHandler rejectionHandler) {
        Validators.validateNotNull(rejectionHandler, "rejectionHandler");
        this.rejectionHandler = rejectionHandler;
        return this;
    }

    @Override
    public void configure(DependencyRegistry dependencyRegistry) {
        this.simpleSecurityConfigurator.configure(dependencyRegistry);
        if (Objects.nonNull(this.rejectionHandler)) {
            CoreModule coreModule = dependencyRegistry.getDependency(CoreModule.class);
            coreModule.addExceptionMapper(throwable -> {
                if (!(throwable instanceof CouldNotAuthenticateException)) {
                    return false;
                }
                return ((CouldNotAuthenticateException)throwable).authenticatorId().equals(this.authenticatorId);
            }, (exception, metaData) -> this.rejectionHandler.handle(metaData));
        }
    }

    @Generated
    public String toString() {
        return "AuthenticatorConfigurator(simpleSecurityConfigurator=" + this.simpleSecurityConfigurator + ", authenticatorId=" + this.authenticatorId + ", optionalRequests=" + this.optionalRequests + ", rejectionHandler=" + this.rejectionHandler + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticatorConfigurator)) {
            return false;
        }
        AuthenticatorConfigurator other = (AuthenticatorConfigurator)o;
        SimpleSecurityConfigurator this$simpleSecurityConfigurator = this.simpleSecurityConfigurator;
        SimpleSecurityConfigurator other$simpleSecurityConfigurator = other.simpleSecurityConfigurator;
        if (this$simpleSecurityConfigurator == null ? other$simpleSecurityConfigurator != null : !((Object)this$simpleSecurityConfigurator).equals(other$simpleSecurityConfigurator)) {
            return false;
        }
        AuthenticatorId this$authenticatorId = this.authenticatorId;
        AuthenticatorId other$authenticatorId = other.authenticatorId;
        if (this$authenticatorId == null ? other$authenticatorId != null : !((Object)this$authenticatorId).equals(other$authenticatorId)) {
            return false;
        }
        List<Filter> this$optionalRequests = this.optionalRequests;
        List<Filter> other$optionalRequests = other.optionalRequests;
        if (this$optionalRequests == null ? other$optionalRequests != null : !((Object)this$optionalRequests).equals(other$optionalRequests)) {
            return false;
        }
        HttpHandler this$rejectionHandler = this.rejectionHandler;
        HttpHandler other$rejectionHandler = other.rejectionHandler;
        return !(this$rejectionHandler == null ? other$rejectionHandler != null : !this$rejectionHandler.equals(other$rejectionHandler));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SimpleSecurityConfigurator $simpleSecurityConfigurator = this.simpleSecurityConfigurator;
        result = result * 59 + ($simpleSecurityConfigurator == null ? 43 : ((Object)$simpleSecurityConfigurator).hashCode());
        AuthenticatorId $authenticatorId = this.authenticatorId;
        result = result * 59 + ($authenticatorId == null ? 43 : ((Object)$authenticatorId).hashCode());
        List<Filter> $optionalRequests = this.optionalRequests;
        result = result * 59 + ($optionalRequests == null ? 43 : ((Object)$optionalRequests).hashCode());
        HttpHandler $rejectionHandler = this.rejectionHandler;
        result = result * 59 + ($rejectionHandler == null ? 43 : $rejectionHandler.hashCode());
        return result;
    }

    @Generated
    private AuthenticatorConfigurator(SimpleSecurityConfigurator simpleSecurityConfigurator, AuthenticatorId authenticatorId, List<Filter> optionalRequests) {
        this.simpleSecurityConfigurator = simpleSecurityConfigurator;
        this.authenticatorId = authenticatorId;
        this.optionalRequests = optionalRequests;
    }
}

