/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.generator;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.generator.GenerationCondition;
import de.quantummaid.httpmaid.http.HttpRequestMethod;
import de.quantummaid.httpmaid.http.PathParameters;
import de.quantummaid.httpmaid.path.Path;
import de.quantummaid.httpmaid.path.PathTemplate;
import de.quantummaid.httpmaid.util.Validators;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public final class PathAndMethodGenerationCondition
implements GenerationCondition {
    private static final List<HttpRequestMethod> METHOD_WHITELIST = Arrays.asList(HttpRequestMethod.GET, HttpRequestMethod.POST, HttpRequestMethod.PUT, HttpRequestMethod.DELETE);
    private final PathTemplate pathTemplate;
    private final HttpRequestMethod[] methods;

    public static PathAndMethodGenerationCondition pathAndMethodEventTypeGenerationCondition(PathTemplate pathTemplate, HttpRequestMethod ... methods) {
        Validators.validateNotNull(pathTemplate, "pathTemplate");
        Validators.validateArrayNeitherNullNorEmptyNorContainsNull(methods, "methods");
        Arrays.stream(methods).forEach(method -> {
            if (!METHOD_WHITELIST.contains(method)) {
                throw new IllegalArgumentException(String.format("Use cases cannot be registered on the %s method.", method.name()));
            }
        });
        return new PathAndMethodGenerationCondition(pathTemplate, methods);
    }

    @Override
    public List<String> pathParameters() {
        return this.pathTemplate.parameters();
    }

    @Override
    public boolean isSubsetOf(GenerationCondition other) {
        Validators.validateNotNull(other, "other");
        return this.equals(other);
    }

    @Override
    public boolean generate(MetaData metaData) {
        if (!metaData.contains(HttpMaidChainKeys.METHOD)) {
            return false;
        }
        HttpRequestMethod method = metaData.get(HttpMaidChainKeys.METHOD);
        if (Arrays.stream(this.methods).noneMatch(method::equals)) {
            return false;
        }
        if (!metaData.contains(HttpMaidChainKeys.PATH)) {
            return false;
        }
        Path path = metaData.get(HttpMaidChainKeys.PATH);
        if (!this.pathTemplate.matches(path)) {
            return false;
        }
        Map<String, String> pathParameters = this.pathTemplate.extractPathParameters(path);
        metaData.set(HttpMaidChainKeys.PATH_PARAMETERS, PathParameters.pathParameters(pathParameters));
        return true;
    }

    @Generated
    public String toString() {
        return "PathAndMethodGenerationCondition(pathTemplate=" + this.pathTemplate + ", methods=" + Arrays.deepToString(this.methods) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PathAndMethodGenerationCondition)) {
            return false;
        }
        PathAndMethodGenerationCondition other = (PathAndMethodGenerationCondition)o;
        PathTemplate this$pathTemplate = this.pathTemplate;
        PathTemplate other$pathTemplate = other.pathTemplate;
        if (this$pathTemplate == null ? other$pathTemplate != null : !((Object)this$pathTemplate).equals(other$pathTemplate)) {
            return false;
        }
        return Arrays.deepEquals(this.methods, other.methods);
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PathTemplate $pathTemplate = this.pathTemplate;
        result = result * 59 + ($pathTemplate == null ? 43 : ((Object)$pathTemplate).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.methods);
        return result;
    }

    @Generated
    private PathAndMethodGenerationCondition(PathTemplate pathTemplate, HttpRequestMethod[] methods) {
        this.pathTemplate = pathTemplate;
        this.methods = methods;
    }
}

