/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid;

import de.quantummaid.httpmaid.HttpMaidBuilder;
import de.quantummaid.httpmaid.HttpMaidChains;
import de.quantummaid.httpmaid.chains.ChainName;
import de.quantummaid.httpmaid.chains.ChainRegistry;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.MetaDataKey;
import de.quantummaid.httpmaid.closing.ClosingActions;
import de.quantummaid.httpmaid.endpoint.RawRequest;
import de.quantummaid.httpmaid.endpoint.RawRequestExtractor;
import de.quantummaid.httpmaid.endpoint.RawResponse;
import de.quantummaid.httpmaid.endpoint.RawResponseFactory;
import de.quantummaid.httpmaid.endpoint.RawResponseHandler;
import de.quantummaid.httpmaid.endpoint.SynchronizationWrapper;
import de.quantummaid.httpmaid.util.Validators;
import java.time.Duration;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpMaid
implements AutoCloseable {
    public static final MetaDataKey<Duration> STARTUP_TIME = MetaDataKey.metaDataKey("STARTUP_TIME");
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpMaid.class);
    private final ChainRegistry chainRegistry;

    public static HttpMaid httpMaid(ChainRegistry chainRegistry) {
        Validators.validateNotNull(chainRegistry, "chainRegistry");
        return new HttpMaid(chainRegistry);
    }

    public void handle(ChainName chainName, MetaData metaData) {
        this.chainRegistry.putIntoChain(chainName, metaData, metaData1 -> {});
    }

    public <T> T handleRequestSynchronously(RawRequestExtractor rawRequestExtractor, RawResponseFactory<T> rawResponseFactory) {
        SynchronizationWrapper synchronizationWrapper = SynchronizationWrapper.synchronizationWrapper();
        this.handleRequest(rawRequestExtractor, response -> {
            Object returnedResponse = rawResponseFactory.createResponse(response);
            synchronizationWrapper.setObject(returnedResponse);
        });
        return synchronizationWrapper.getObject();
    }

    public void handleRequest(RawRequestExtractor rawRequestExtractor, RawResponseHandler rawResponseHandler) {
        RawRequest rawRequest;
        try {
            rawRequest = rawRequestExtractor.extract();
        }
        catch (Exception e) {
            LOGGER.error("Exception in endpoint request handling", (Throwable)e);
            return;
        }
        MetaData metaData = MetaData.emptyMetaData();
        rawRequest.enter(metaData);
        this.chainRegistry.putIntoChain(HttpMaidChains.INIT, metaData, finalMetaData -> {
            RawResponse rawResponse = RawResponse.rawResponse(finalMetaData);
            try {
                rawResponseHandler.handle(rawResponse);
            }
            catch (Exception e) {
                LOGGER.error("Exception in endpoint reponse handling", (Throwable)e);
            }
        });
    }

    public <T> T getMetaDatum(MetaDataKey<T> key) {
        Validators.validateNotNull(key, "key");
        return this.chainRegistry.getMetaDatum(key);
    }

    public <T> Optional<T> getOptionalMetaDatum(MetaDataKey<T> key) {
        Validators.validateNotNull(key, "key");
        return this.chainRegistry.getOptionalMetaDatum(key);
    }

    public <T> void setMetaDatum(MetaDataKey<T> key, T value) {
        this.chainRegistry.addMetaDatum(key, value);
    }

    public String dumpChains() {
        return this.chainRegistry.dump();
    }

    public static HttpMaidBuilder anHttpMaid() {
        return HttpMaidBuilder.httpMaidBuilder();
    }

    @Override
    public void close() {
        ClosingActions closingActions = this.chainRegistry.getMetaDatum(ClosingActions.CLOSING_ACTIONS);
        closingActions.closeAll();
    }

    @Generated
    private HttpMaid(ChainRegistry chainRegistry) {
        this.chainRegistry = chainRegistry;
    }
}

