/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.HttpMaidChains;
import de.quantummaid.httpmaid.PerRouteConfigurator;
import de.quantummaid.httpmaid.chains.ChainExtender;
import de.quantummaid.httpmaid.chains.ChainModule;
import de.quantummaid.httpmaid.chains.DependencyRegistry;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.chains.builder.ChainBuilder;
import de.quantummaid.httpmaid.chains.rules.Consume;
import de.quantummaid.httpmaid.chains.rules.Jump;
import de.quantummaid.httpmaid.closing.ClosingActions;
import de.quantummaid.httpmaid.exceptions.DefaultExceptionMapper;
import de.quantummaid.httpmaid.exceptions.ExceptionMapper;
import de.quantummaid.httpmaid.exceptions.ExceptionSerializer;
import de.quantummaid.httpmaid.exceptions.HandlerExceptionMapper;
import de.quantummaid.httpmaid.filtermap.FilterMapBuilder;
import de.quantummaid.httpmaid.generator.GenerationCondition;
import de.quantummaid.httpmaid.generator.Generator;
import de.quantummaid.httpmaid.generator.Generators;
import de.quantummaid.httpmaid.handler.DefaultPageNotFoundHandler;
import de.quantummaid.httpmaid.handler.DetermineHandlerProcessor;
import de.quantummaid.httpmaid.handler.Handler;
import de.quantummaid.httpmaid.handler.InvokeHandlerProcessor;
import de.quantummaid.httpmaid.handler.PageNotFoundException;
import de.quantummaid.httpmaid.handler.distribution.DistributableHandler;
import de.quantummaid.httpmaid.handler.distribution.HandlerDistributors;
import de.quantummaid.httpmaid.processors.MapExceptionProcessor;
import de.quantummaid.httpmaid.processors.StreamToStringProcessor;
import de.quantummaid.httpmaid.processors.StringBodyToStreamProcessor;
import de.quantummaid.httpmaid.processors.TranslateToValueObjectsProcessor;
import de.quantummaid.httpmaid.responsetemplate.ApplyResponseTemplateProcessor;
import de.quantummaid.httpmaid.responsetemplate.InitResponseProcessor;
import de.quantummaid.httpmaid.responsetemplate.ResponseTemplate;
import de.quantummaid.httpmaid.startupchecks.StartupChecks;
import de.quantummaid.httpmaid.util.Validators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import lombok.Generated;

public final class CoreModule
implements ChainModule {
    private final List<DistributableHandler> handlers = new ArrayList<DistributableHandler>();
    private final List<Generator<Handler>> lowLevelHandlers = new LinkedList<Generator<Handler>>();
    private ResponseTemplate responseTemplate = ResponseTemplate.emptyResponseTemplate();
    private final FilterMapBuilder<Throwable, ExceptionMapper<Throwable>> exceptionMappers = FilterMapBuilder.filterMapBuilder();
    private ExceptionMapper<?> pageNotFoundExceptionMapper = HandlerExceptionMapper.handlerExceptionMapper(DefaultPageNotFoundHandler.defaultPageNotFoundHandler());
    private final ClosingActions closingActions = ClosingActions.closingActions();

    public static CoreModule coreModule() {
        CoreModule coreModule = new CoreModule();
        coreModule.setDefaultExceptionMapper(DefaultExceptionMapper.theDefaultExceptionMapper());
        return coreModule;
    }

    public void registerHandler(GenerationCondition condition, Object handler, List<PerRouteConfigurator> perRouteConfigurators) {
        Validators.validateNotNull(condition, "generationCondition");
        Validators.validateNotNull(handler, "handler");
        Validators.validateNotNull(perRouteConfigurators, "perRouteConfigurators");
        this.handlers.add(DistributableHandler.distributableHandler(condition, handler, perRouteConfigurators));
    }

    public void setResponseTemplate(ResponseTemplate responseTemplate) {
        Validators.validateNotNull(responseTemplate, "responseTemplate");
        this.responseTemplate = responseTemplate;
    }

    public void setPageNotFoundExceptionMapper(ExceptionMapper<PageNotFoundException> pageNotFoundExceptionMapper) {
        Validators.validateNotNull(pageNotFoundExceptionMapper, "pageNotFoundExceptionMapper");
        this.pageNotFoundExceptionMapper = pageNotFoundExceptionMapper;
    }

    public void addExceptionMapper(Predicate<Throwable> filter, ExceptionMapper<Throwable> responseMapper) {
        Validators.validateNotNull(filter, "filter");
        Validators.validateNotNull(responseMapper, "responseMapper");
        this.exceptionMappers.put(filter, responseMapper);
    }

    public void setDefaultExceptionMapper(ExceptionMapper<Throwable> responseMapper) {
        Validators.validateNotNull(responseMapper, "responseMapper");
        this.exceptionMappers.setDefaultValue(responseMapper);
    }

    @Override
    public void init(MetaData configurationMetaData) {
        StartupChecks startupChecks = StartupChecks.startupChecks();
        configurationMetaData.set(StartupChecks.STARTUP_CHECKS, startupChecks);
        HandlerDistributors handlerDistributers = HandlerDistributors.handlerDistributors();
        configurationMetaData.set(HandlerDistributors.HANDLER_DISTRIBUTORS, handlerDistributers);
        handlerDistributers.register(handler -> handler.handler() instanceof Handler, handler -> {
            Generator<Handler> generator = Generator.generator((Handler)handler.handler(), handler.condition());
            this.lowLevelHandlers.add(generator);
            return Collections.emptyList();
        });
    }

    @Override
    public void configure(DependencyRegistry dependencyRegistry) {
        HandlerDistributors handlerDistributors = dependencyRegistry.getMetaDatum(HandlerDistributors.HANDLER_DISTRIBUTORS);
        this.handlers.forEach(handler -> handlerDistributors.distribute((DistributableHandler)handler, dependencyRegistry));
    }

    @Override
    public void register(ChainExtender extender) {
        this.addExceptionMapper(throwable -> throwable instanceof PageNotFoundException, this.pageNotFoundExceptionMapper);
        ExceptionSerializer exceptionSerializer = ExceptionSerializer.exceptionSerializer(this.exceptionMappers.build());
        ChainBuilder.extendAChainWith(extender).append(HttpMaidChains.INIT, new Processor[0]).append(HttpMaidChains.PRE_PROCESS, TranslateToValueObjectsProcessor.translateToValueObjectsProcessor()).append(HttpMaidChains.PROCESS_HEADERS, new Processor[0]).append(HttpMaidChains.PROCESS_BODY, new Processor[0]).append(HttpMaidChains.PROCESS_BODY_STRING, StreamToStringProcessor.streamToStringProcessor()).append(HttpMaidChains.DETERMINE_HANDLER, DetermineHandlerProcessor.determineHandlerProcessor(Generators.generators(this.lowLevelHandlers))).append(HttpMaidChains.PREPARE_RESPONSE, InitResponseProcessor.initResponseProcessor(), ApplyResponseTemplateProcessor.applyResponseTemplateProcessor(this.responseTemplate)).append(HttpMaidChains.INVOKE_HANDLER, InvokeHandlerProcessor.invokeHandlerProcessor()).append(HttpMaidChains.POST_INVOKE, new Processor[0]).withTheExceptionChain(HttpMaidChains.EXCEPTION_OCCURRED).withTheFinalAction(Jump.jumpTo(HttpMaidChains.POST_PROCESS));
        ChainBuilder.extendAChainWith(extender).append(HttpMaidChains.EXCEPTION_OCCURRED, new Processor[0]).append(HttpMaidChains.PREPARE_EXCEPTION_RESPONSE, InitResponseProcessor.initResponseProcessor(), metaData -> metaData.set(HttpMaidChainKeys.RESPONSE_STATUS, 500)).append(HttpMaidChains.MAP_EXCEPTION_TO_RESPONSE, MapExceptionProcessor.mapExceptionProcessor(exceptionSerializer)).withTheExceptionChain(HttpMaidChains.ERROR).withTheFinalAction(Jump.jumpTo(HttpMaidChains.POST_INVOKE));
        extender.createChain(HttpMaidChains.POST_PROCESS, Consume.consume(), Jump.jumpTo(HttpMaidChains.ERROR));
        extender.appendProcessor(HttpMaidChains.POST_PROCESS, StringBodyToStreamProcessor.stringBodyToStreamProcessor());
        extender.createChain(HttpMaidChains.ERROR, Consume.consume(), Consume.consume());
        extender.addMetaDatum(ClosingActions.CLOSING_ACTIONS, this.closingActions);
    }

    @Generated
    public String toString() {
        return "CoreModule(handlers=" + this.handlers + ", lowLevelHandlers=" + this.lowLevelHandlers + ", responseTemplate=" + this.responseTemplate + ", exceptionMappers=" + this.exceptionMappers + ", pageNotFoundExceptionMapper=" + this.pageNotFoundExceptionMapper + ", closingActions=" + this.closingActions + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CoreModule)) {
            return false;
        }
        CoreModule other = (CoreModule)o;
        List<DistributableHandler> this$handlers = this.handlers;
        List<DistributableHandler> other$handlers = other.handlers;
        if (this$handlers == null ? other$handlers != null : !((Object)this$handlers).equals(other$handlers)) {
            return false;
        }
        List<Generator<Handler>> this$lowLevelHandlers = this.lowLevelHandlers;
        List<Generator<Handler>> other$lowLevelHandlers = other.lowLevelHandlers;
        if (this$lowLevelHandlers == null ? other$lowLevelHandlers != null : !((Object)this$lowLevelHandlers).equals(other$lowLevelHandlers)) {
            return false;
        }
        ResponseTemplate this$responseTemplate = this.responseTemplate;
        ResponseTemplate other$responseTemplate = other.responseTemplate;
        if (this$responseTemplate == null ? other$responseTemplate != null : !this$responseTemplate.equals(other$responseTemplate)) {
            return false;
        }
        FilterMapBuilder<Throwable, ExceptionMapper<Throwable>> this$exceptionMappers = this.exceptionMappers;
        FilterMapBuilder<Throwable, ExceptionMapper<Throwable>> other$exceptionMappers = other.exceptionMappers;
        if (this$exceptionMappers == null ? other$exceptionMappers != null : !this$exceptionMappers.equals(other$exceptionMappers)) {
            return false;
        }
        ExceptionMapper<?> this$pageNotFoundExceptionMapper = this.pageNotFoundExceptionMapper;
        ExceptionMapper<?> other$pageNotFoundExceptionMapper = other.pageNotFoundExceptionMapper;
        if (this$pageNotFoundExceptionMapper == null ? other$pageNotFoundExceptionMapper != null : !this$pageNotFoundExceptionMapper.equals(other$pageNotFoundExceptionMapper)) {
            return false;
        }
        ClosingActions this$closingActions = this.closingActions;
        ClosingActions other$closingActions = other.closingActions;
        return !(this$closingActions == null ? other$closingActions != null : !((Object)this$closingActions).equals(other$closingActions));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<DistributableHandler> $handlers = this.handlers;
        result = result * 59 + ($handlers == null ? 43 : ((Object)$handlers).hashCode());
        List<Generator<Handler>> $lowLevelHandlers = this.lowLevelHandlers;
        result = result * 59 + ($lowLevelHandlers == null ? 43 : ((Object)$lowLevelHandlers).hashCode());
        ResponseTemplate $responseTemplate = this.responseTemplate;
        result = result * 59 + ($responseTemplate == null ? 43 : $responseTemplate.hashCode());
        FilterMapBuilder<Throwable, ExceptionMapper<Throwable>> $exceptionMappers = this.exceptionMappers;
        result = result * 59 + ($exceptionMappers == null ? 43 : $exceptionMappers.hashCode());
        ExceptionMapper<?> $pageNotFoundExceptionMapper = this.pageNotFoundExceptionMapper;
        result = result * 59 + ($pageNotFoundExceptionMapper == null ? 43 : $pageNotFoundExceptionMapper.hashCode());
        ClosingActions $closingActions = this.closingActions;
        result = result * 59 + ($closingActions == null ? 43 : ((Object)$closingActions).hashCode());
        return result;
    }

    @Generated
    private CoreModule() {
    }
}

