/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.http.headers.accept;

import de.quantummaid.httpmaid.http.headers.accept.MimeType;
import de.quantummaid.httpmaid.http.headers.accept.MimeTypeElementMatcher;
import de.quantummaid.httpmaid.util.Validators;
import lombok.Generated;

public final class MimeTypeMatcher {
    private final MimeTypeElementMatcher type;
    private final MimeTypeElementMatcher subtype;

    static MimeTypeMatcher parseMimeTypeMatcher(String string) {
        Validators.validateNotNullNorEmpty(string, "string");
        MimeType mimeType = MimeType.parseMimeType(string);
        MimeTypeElementMatcher type = MimeTypeElementMatcher.parse(mimeType.type());
        MimeTypeElementMatcher subtype = MimeTypeElementMatcher.parse(mimeType.subtype());
        return new MimeTypeMatcher(type, subtype);
    }

    public boolean matches(MimeType mimeType) {
        Validators.validateNotNull(mimeType, "mimeType");
        return this.type.matches(mimeType.type()) && this.subtype.matches(mimeType.subtype());
    }

    @Generated
    public String toString() {
        return "MimeTypeMatcher(type=" + this.type + ", subtype=" + this.subtype + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MimeTypeMatcher)) {
            return false;
        }
        MimeTypeMatcher other = (MimeTypeMatcher)o;
        MimeTypeElementMatcher this$type = this.type;
        MimeTypeElementMatcher other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        MimeTypeElementMatcher this$subtype = this.subtype;
        MimeTypeElementMatcher other$subtype = other.subtype;
        return !(this$subtype == null ? other$subtype != null : !this$subtype.equals(other$subtype));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MimeTypeElementMatcher $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        MimeTypeElementMatcher $subtype = this.subtype;
        result = result * 59 + ($subtype == null ? 43 : $subtype.hashCode());
        return result;
    }

    @Generated
    private MimeTypeMatcher(MimeTypeElementMatcher type, MimeTypeElementMatcher subtype) {
        this.type = type;
        this.subtype = subtype;
    }
}

