/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.security.basicauth;

import de.quantummaid.httpmaid.handler.http.HttpRequest;
import de.quantummaid.httpmaid.security.authentication.Authenticator;
import de.quantummaid.httpmaid.security.authorization.AuthorizationHeader;
import de.quantummaid.httpmaid.security.basicauth.Base64Decoder;
import de.quantummaid.httpmaid.security.basicauth.BasicAuthAuthenticator;
import de.quantummaid.httpmaid.util.Validators;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public final class BasicAuthAuthentication
implements Authenticator<HttpRequest> {
    private static final Pattern PATTERN = Pattern.compile("(?<username>[^:]++):(?<password>.*+)");
    private final BasicAuthAuthenticator authenticator;

    public static BasicAuthAuthentication basicAuthAuthentication(BasicAuthAuthenticator authenticator) {
        Validators.validateNotNull(authenticator, "authenticator");
        return new BasicAuthAuthentication(authenticator);
    }

    @Override
    public Optional<Object> authenticate(HttpRequest request) {
        return request.headers().getOptionalHeader("Authorization").flatMap(AuthorizationHeader::parse).filter(authorizationHeader -> authorizationHeader.type().equals("Basic")).map(AuthorizationHeader::credentials).map(Base64Decoder::decodeBase64).map(PATTERN::matcher).filter(Matcher::matches).flatMap(matcher -> {
            String password;
            String username = matcher.group("username");
            if (this.authenticator.isAuthenticated(username, password = matcher.group("password"))) {
                return Optional.of(username);
            }
            return Optional.empty();
        });
    }

    @Generated
    public String toString() {
        return "BasicAuthAuthentication(authenticator=" + this.authenticator + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasicAuthAuthentication)) {
            return false;
        }
        BasicAuthAuthentication other = (BasicAuthAuthentication)o;
        BasicAuthAuthenticator this$authenticator = this.authenticator;
        BasicAuthAuthenticator other$authenticator = other.authenticator;
        return !(this$authenticator == null ? other$authenticator != null : !this$authenticator.equals(other$authenticator));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BasicAuthAuthenticator $authenticator = this.authenticator;
        result = result * 59 + ($authenticator == null ? 43 : $authenticator.hashCode());
        return result;
    }

    @Generated
    private BasicAuthAuthentication(BasicAuthAuthenticator authenticator) {
        this.authenticator = authenticator;
    }
}

