/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid;

import de.quantummaid.httpmaid.HttpMaidBuilder;
import de.quantummaid.httpmaid.PerRouteConfigurator;
import de.quantummaid.httpmaid.chains.Configurator;
import de.quantummaid.httpmaid.chains.ConfiguratorBuilder;
import de.quantummaid.httpmaid.generator.builder.ConditionStage;
import de.quantummaid.httpmaid.handler.Handler;
import de.quantummaid.httpmaid.handler.http.HttpHandler;
import de.quantummaid.httpmaid.http.HttpRequestMethod;
import de.quantummaid.httpmaid.util.Validators;

public interface HttpConfiguration {
    default public HttpMaidBuilder get(String url, Object handler, PerRouteConfigurator ... perRouteConfigurators) {
        return this.serving(handler, perRouteConfigurators).forRequestPath(url).andRequestMethod(HttpRequestMethod.GET);
    }

    default public HttpMaidBuilder get(String url, HttpHandler handler, PerRouteConfigurator ... perRouteConfigurators) {
        return this.get(url, (Object)handler, perRouteConfigurators);
    }

    default public HttpMaidBuilder post(String url, Object handler, PerRouteConfigurator ... perRouteConfigurators) {
        return this.serving(handler, perRouteConfigurators).forRequestPath(url).andRequestMethod(HttpRequestMethod.POST);
    }

    default public HttpMaidBuilder post(String url, HttpHandler handler) {
        return this.post(url, handler, new PerRouteConfigurator[0]);
    }

    default public HttpMaidBuilder put(String url, Object handler, PerRouteConfigurator ... perRouteConfigurators) {
        return this.serving(handler, perRouteConfigurators).forRequestPath(url).andRequestMethod(HttpRequestMethod.PUT);
    }

    default public HttpMaidBuilder put(String url, HttpHandler handler) {
        return this.put(url, handler, new PerRouteConfigurator[0]);
    }

    default public HttpMaidBuilder delete(String url, Object handler, PerRouteConfigurator ... perRouteConfigurators) {
        return this.serving(handler, perRouteConfigurators).forRequestPath(url).andRequestMethod(HttpRequestMethod.DELETE);
    }

    default public HttpMaidBuilder delete(String url, HttpHandler handler) {
        return this.delete(url, handler, new PerRouteConfigurator[0]);
    }

    default public ConditionStage<HttpMaidBuilder> serving(Handler handler) {
        return this.serving(handler, new PerRouteConfigurator[0]);
    }

    public ConditionStage<HttpMaidBuilder> serving(Object var1, PerRouteConfigurator ... var2);

    default public HttpMaidBuilder configured(ConfiguratorBuilder configuratorBuilder) {
        Validators.validateNotNull(configuratorBuilder, "configuratorBuilder");
        Configurator configurator = configuratorBuilder.build();
        return this.configured(configurator);
    }

    public HttpMaidBuilder configured(Configurator var1);
}

