/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.cors;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.HttpMaidChains;
import de.quantummaid.httpmaid.chains.ChainExtender;
import de.quantummaid.httpmaid.chains.ChainModule;
import de.quantummaid.httpmaid.chains.ChainName;
import de.quantummaid.httpmaid.chains.rules.Jump;
import de.quantummaid.httpmaid.cors.PreflightRequestProcessor;
import de.quantummaid.httpmaid.cors.SimpleCrossOriginRequestProcessor;
import de.quantummaid.httpmaid.cors.policy.ResourceSharingPolicy;
import de.quantummaid.httpmaid.http.HttpRequestMethod;
import de.quantummaid.httpmaid.util.Validators;
import lombok.Generated;

public final class CorsModule
implements ChainModule {
    private static final ChainName CORS_CHAIN = ChainName.chainName("CORS");
    private ResourceSharingPolicy resourceSharingPolicy;

    public static ChainModule corsModule() {
        return new CorsModule();
    }

    public void setResourceSharingPolicy(ResourceSharingPolicy resourceSharingPolicy) {
        Validators.validateNotNull(resourceSharingPolicy, "resourceSharingPolicy");
        this.resourceSharingPolicy = resourceSharingPolicy;
    }

    @Override
    public void register(ChainExtender extender) {
        extender.createChain(CORS_CHAIN, Jump.jumpTo(HttpMaidChains.POST_PROCESS), Jump.jumpTo(HttpMaidChains.EXCEPTION_OCCURRED));
        extender.appendProcessor(CORS_CHAIN, PreflightRequestProcessor.preflightRequestProcessor(this.resourceSharingPolicy));
        extender.routeIfEquals(HttpMaidChains.PRE_PROCESS, Jump.jumpTo(CORS_CHAIN), HttpMaidChainKeys.METHOD, HttpRequestMethod.OPTIONS);
        extender.appendProcessor(HttpMaidChains.PREPARE_RESPONSE, SimpleCrossOriginRequestProcessor.simpleCrossOriginRequestProcessor(this.resourceSharingPolicy));
    }

    @Generated
    public String toString() {
        return "CorsModule(resourceSharingPolicy=" + this.resourceSharingPolicy + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CorsModule)) {
            return false;
        }
        CorsModule other = (CorsModule)o;
        ResourceSharingPolicy this$resourceSharingPolicy = this.resourceSharingPolicy;
        ResourceSharingPolicy other$resourceSharingPolicy = other.resourceSharingPolicy;
        return !(this$resourceSharingPolicy == null ? other$resourceSharingPolicy != null : !((Object)this$resourceSharingPolicy).equals(other$resourceSharingPolicy));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResourceSharingPolicy $resourceSharingPolicy = this.resourceSharingPolicy;
        result = result * 59 + ($resourceSharingPolicy == null ? 43 : ((Object)$resourceSharingPolicy).hashCode());
        return result;
    }

    @Generated
    private CorsModule() {
    }
}

