/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.marshalling;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.HttpMaidChains;
import de.quantummaid.httpmaid.chains.ChainExtender;
import de.quantummaid.httpmaid.chains.ChainModule;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.handler.http.HttpRequest;
import de.quantummaid.httpmaid.http.headers.ContentType;
import de.quantummaid.httpmaid.http.headers.accept.Accept;
import de.quantummaid.httpmaid.marshalling.DefaultContentTypeProvider;
import de.quantummaid.httpmaid.marshalling.Marshaller;
import de.quantummaid.httpmaid.marshalling.MarshallingException;
import de.quantummaid.httpmaid.marshalling.ResponseContentTypeCouldNotBeDeterminedException;
import de.quantummaid.httpmaid.marshalling.Unmarshaller;
import de.quantummaid.httpmaid.marshalling.UnsupportedContentTypeException;
import de.quantummaid.httpmaid.util.Validators;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MarshallingModule
implements ChainModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(MarshallingModule.class);
    private DefaultContentTypeProvider defaultContentTypeProvider;
    private final Map<ContentType, Unmarshaller> unmarshallers;
    private final Map<ContentType, Marshaller> marshallers;
    private boolean throwExceptionIfNoMarshallerFound;

    public static MarshallingModule emptyMarshallingModule() {
        return new MarshallingModule(new HashMap<ContentType, Unmarshaller>(), new HashMap<ContentType, Marshaller>());
    }

    public void addUnmarshaller(ContentType contentType, Unmarshaller unmarshaller) {
        Validators.validateNotNull(contentType, "contentType");
        Validators.validateNotNull(unmarshaller, "unmarshaller");
        this.unmarshallers.put(contentType, unmarshaller);
        if (this.defaultContentTypeProvider == null) {
            this.setDefaultContentTypeProvider(contentType);
        }
    }

    public void addMarshaller(ContentType contentType, Marshaller marshaller) {
        Validators.validateNotNull(contentType, "contentType");
        Validators.validateNotNull(marshaller, "marshaller");
        this.marshallers.put(contentType, marshaller);
        if (this.defaultContentTypeProvider == null) {
            this.setDefaultContentTypeProvider(contentType);
        }
    }

    public void setDefaultContentTypeProvider(ContentType defaultContentTypeProvider) {
        Validators.validateNotNull(defaultContentTypeProvider, "defaultContentType");
        this.setDefaultContentTypeProvider((HttpRequest request) -> defaultContentTypeProvider);
    }

    public void setDefaultContentTypeProvider(DefaultContentTypeProvider defaultContentType) {
        Validators.validateNotNull(defaultContentType, "defaultContentType");
        this.defaultContentTypeProvider = defaultContentType;
    }

    public void setThrowExceptionIfNoMarshallerFound(boolean throwExceptionIfNoMarshallerFound) {
        this.throwExceptionIfNoMarshallerFound = throwExceptionIfNoMarshallerFound;
    }

    @Override
    public void register(ChainExtender extender) {
        extender.appendProcessor(HttpMaidChains.PROCESS_BODY_STRING, this::processUnmarshalling);
        extender.prependProcessor(HttpMaidChains.POST_INVOKE, this::processMarshalling);
    }

    private void processUnmarshalling(MetaData metaData) {
        metaData.getOptional(HttpMaidChainKeys.REQUEST_BODY_STRING).ifPresent(body -> {
            Unmarshaller unmarshaller;
            ContentType contentType = metaData.get(HttpMaidChainKeys.REQUEST_CONTENT_TYPE);
            if (contentType.isEmpty()) {
                unmarshaller = this.defaultUnmarshaller(metaData);
            } else if (this.unmarshallers.containsKey(contentType)) {
                unmarshaller = this.unmarshallers.get(contentType);
            } else if (!this.throwExceptionIfNoMarshallerFound) {
                unmarshaller = this.defaultUnmarshaller(metaData);
            } else {
                throw UnsupportedContentTypeException.unsupportedContentTypeException(contentType, this.unmarshallers.keySet());
            }
            if (Objects.nonNull(unmarshaller)) {
                try {
                    Object unmarshalled = unmarshaller.unmarshall((String)body);
                    metaData.set(HttpMaidChainKeys.UNMARSHALLED_REQUEST_BODY, unmarshalled);
                }
                catch (Exception e) {
                    LOGGER.info("exception during marshalling", (Throwable)e);
                }
            }
        });
    }

    private Unmarshaller defaultUnmarshaller(MetaData metaData) {
        HttpRequest request = HttpRequest.httpRequest(metaData);
        ContentType defaultContentType = this.defaultContentTypeProvider.provideDefaultContentType(request);
        return this.unmarshallers.get(defaultContentType);
    }

    private void processMarshalling(MetaData metaData) {
        block2: {
            try {
                metaData.getOptional(HttpMaidChainKeys.RESPONSE_BODY_OBJECT).ifPresent(map -> {
                    ContentType responseContentType = this.determineResponseContentType(metaData);
                    Marshaller marshaller = this.marshallerFor(responseContentType);
                    metaData.set(HttpMaidChainKeys.RESPONSE_CONTENT_TYPE, responseContentType);
                    String stringBody = marshaller.marshall(map);
                    metaData.set(HttpMaidChainKeys.RESPONSE_BODY_STRING, stringBody);
                });
            }
            catch (MarshallingException e) {
                if (!metaData.getOptional(HttpMaidChainKeys.EXCEPTION).isEmpty()) break block2;
                this.failIfConfiguredToDoSo(() -> MarshallingException.marshallingException(e));
            }
        }
    }

    private Marshaller marshallerFor(ContentType responseContentType) {
        Marshaller marshaller = this.marshallers.get(responseContentType);
        if (Objects.isNull(marshaller)) {
            throw UnsupportedContentTypeException.unsupportedContentTypeException(responseContentType, this.marshallers.keySet());
        }
        return marshaller;
    }

    private ContentType determineResponseContentType(MetaData metaData) {
        Optional<ContentType> responseContentType = MarshallingModule.responseContentType(metaData);
        if (responseContentType.isPresent()) {
            return responseContentType.get();
        }
        Accept accept = Accept.fromMetaData(metaData);
        List candidates = this.marshallers.keySet().stream().filter(accept::contentTypeIsAccepted).collect(Collectors.toList());
        if (candidates.isEmpty()) {
            return this.defaultResponseContentType(metaData).orElseThrow(() -> ResponseContentTypeCouldNotBeDeterminedException.responseContentTypeCouldNotBeDeterminedException(metaData));
        }
        Optional<ContentType> requestContentType = metaData.getOptional(HttpMaidChainKeys.REQUEST_CONTENT_TYPE).filter(candidates::contains);
        if (requestContentType.isPresent()) {
            return requestContentType.get();
        }
        HttpRequest request = HttpRequest.httpRequest(metaData);
        ContentType defaultContentType = this.defaultContentTypeProvider.provideDefaultContentType(request);
        if (candidates.contains(defaultContentType)) {
            return defaultContentType;
        }
        return (ContentType)candidates.get(0);
    }

    private Optional<ContentType> defaultResponseContentType(MetaData metaData) {
        if (this.marshallers.isEmpty()) {
            return Optional.empty();
        }
        HttpRequest request = HttpRequest.httpRequest(metaData);
        ContentType defaultContentType = this.defaultContentTypeProvider.provideDefaultContentType(request);
        if (this.marshallers.containsKey(defaultContentType)) {
            return Optional.ofNullable(defaultContentType);
        }
        return Optional.ofNullable(this.marshallers.keySet().iterator().next());
    }

    private static Optional<ContentType> responseContentType(MetaData metaData) {
        return metaData.getOptional(HttpMaidChainKeys.RESPONSE_HEADERS).flatMap(headers -> headers.getOptionalHeader("Content-Type").map(ContentType::fromString));
    }

    private void failIfConfiguredToDoSo(Supplier<RuntimeException> exceptionSupplier) {
        if (this.throwExceptionIfNoMarshallerFound) {
            throw exceptionSupplier.get();
        }
    }

    @Generated
    public String toString() {
        return "MarshallingModule(defaultContentTypeProvider=" + this.defaultContentTypeProvider + ", unmarshallers=" + this.unmarshallers + ", marshallers=" + this.marshallers + ", throwExceptionIfNoMarshallerFound=" + this.throwExceptionIfNoMarshallerFound + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MarshallingModule)) {
            return false;
        }
        MarshallingModule other = (MarshallingModule)o;
        DefaultContentTypeProvider this$defaultContentTypeProvider = this.defaultContentTypeProvider;
        DefaultContentTypeProvider other$defaultContentTypeProvider = other.defaultContentTypeProvider;
        if (this$defaultContentTypeProvider == null ? other$defaultContentTypeProvider != null : !this$defaultContentTypeProvider.equals(other$defaultContentTypeProvider)) {
            return false;
        }
        Map<ContentType, Unmarshaller> this$unmarshallers = this.unmarshallers;
        Map<ContentType, Unmarshaller> other$unmarshallers = other.unmarshallers;
        if (this$unmarshallers == null ? other$unmarshallers != null : !((Object)this$unmarshallers).equals(other$unmarshallers)) {
            return false;
        }
        Map<ContentType, Marshaller> this$marshallers = this.marshallers;
        Map<ContentType, Marshaller> other$marshallers = other.marshallers;
        if (this$marshallers == null ? other$marshallers != null : !((Object)this$marshallers).equals(other$marshallers)) {
            return false;
        }
        return this.throwExceptionIfNoMarshallerFound == other.throwExceptionIfNoMarshallerFound;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DefaultContentTypeProvider $defaultContentTypeProvider = this.defaultContentTypeProvider;
        result = result * 59 + ($defaultContentTypeProvider == null ? 43 : $defaultContentTypeProvider.hashCode());
        Map<ContentType, Unmarshaller> $unmarshallers = this.unmarshallers;
        result = result * 59 + ($unmarshallers == null ? 43 : ((Object)$unmarshallers).hashCode());
        Map<ContentType, Marshaller> $marshallers = this.marshallers;
        result = result * 59 + ($marshallers == null ? 43 : ((Object)$marshallers).hashCode());
        result = result * 59 + (this.throwExceptionIfNoMarshallerFound ? 79 : 97);
        return result;
    }

    @Generated
    private MarshallingModule(Map<ContentType, Unmarshaller> unmarshallers, Map<ContentType, Marshaller> marshallers) {
        this.unmarshallers = unmarshallers;
        this.marshallers = marshallers;
    }
}

