/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid;

import de.quantummaid.httpmaid.HttpMaidBuilder;
import de.quantummaid.httpmaid.HttpMaidChains;
import de.quantummaid.httpmaid.RuntimeInformation;
import de.quantummaid.httpmaid.chains.ChainRegistry;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.MetaDataKey;
import de.quantummaid.httpmaid.closing.ClosingActions;
import de.quantummaid.httpmaid.endpoint.RawRequest;
import de.quantummaid.httpmaid.endpoint.RawRequestExtractor;
import de.quantummaid.httpmaid.endpoint.RawResponse;
import de.quantummaid.httpmaid.endpoint.RawResponseFactory;
import de.quantummaid.httpmaid.endpoint.RawResponseHandler;
import de.quantummaid.httpmaid.endpoint.SynchronizationWrapper;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.WebsocketMetaDataKeys;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistry;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSender;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenderId;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenders;
import java.time.Duration;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpMaid
implements AutoCloseable {
    public static final MetaDataKey<Duration> STARTUP_TIME = MetaDataKey.metaDataKey("STARTUP_TIME");
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpMaid.class);
    private final ChainRegistry chainRegistry;

    public static HttpMaid httpMaid(ChainRegistry chainRegistry) {
        Validators.validateNotNull(chainRegistry, "chainRegistry");
        return new HttpMaid(chainRegistry);
    }

    public <T> T handleRequestSynchronously(RawRequestExtractor<RawRequest> rawRequestExtractor, RawResponseFactory<T> rawResponseFactory) {
        SynchronizationWrapper synchronizationWrapper = SynchronizationWrapper.synchronizationWrapper();
        this.handleRequest(rawRequestExtractor, response -> {
            Object returnedResponse = rawResponseFactory.createResponse(response);
            synchronizationWrapper.setObject(returnedResponse);
        });
        return synchronizationWrapper.getObject();
    }

    public void handleRequest(RawRequestExtractor<RawRequest> rawRequestExtractor, RawResponseHandler rawResponseHandler) {
        RawRequest rawHttpRequest;
        try {
            rawHttpRequest = rawRequestExtractor.extract();
        }
        catch (Exception e) {
            LOGGER.error("Exception in endpoint request handling", (Throwable)e);
            return;
        }
        MetaData metaData = MetaData.emptyMetaData();
        rawHttpRequest.enter(metaData);
        this.chainRegistry.putIntoChain(HttpMaidChains.INIT, metaData, finalMetaData -> {
            RawResponse rawResponse = RawResponse.rawResponse(finalMetaData);
            try {
                rawResponseHandler.handle(rawResponse);
            }
            catch (Exception e) {
                LOGGER.error("Exception in endpoint reponse handling", (Throwable)e);
            }
        });
    }

    public void addWebsocketSender(WebsocketSenderId websocketSenderId, WebsocketSender<?> websocketSender) {
        WebsocketSenders websocketSenders = this.getMetaDatum(WebsocketSenders.WEBSOCKET_SENDERS);
        websocketSenders.addWebsocketSender(websocketSenderId, websocketSender);
    }

    public void setWebsocketRegistry(WebsocketRegistry websocketRegistry) {
        Validators.validateNotNull(websocketRegistry, "websocketRegistry");
        this.chainRegistry.addMetaDatum(WebsocketMetaDataKeys.WEBSOCKET_REGISTRY, websocketRegistry);
    }

    public <T> T getMetaDatum(MetaDataKey<T> key) {
        Validators.validateNotNull(key, "key");
        return this.chainRegistry.getMetaDatum(key);
    }

    public <T> Optional<T> getOptionalMetaDatum(MetaDataKey<T> key) {
        Validators.validateNotNull(key, "key");
        return this.chainRegistry.getOptionalMetaDatum(key);
    }

    public <T> void setMetaDatum(MetaDataKey<T> key, T value) {
        this.chainRegistry.addMetaDatum(key, value);
    }

    public String dumpChains() {
        return this.chainRegistry.dump();
    }

    public RuntimeInformation queryRuntimeInformation() {
        WebsocketRegistry websocketRegistry = this.chainRegistry.getMetaDatum(WebsocketMetaDataKeys.WEBSOCKET_REGISTRY);
        int numberOfConnectedWebsockets = websocketRegistry.countConnections();
        return RuntimeInformation.runtimeInformation(numberOfConnectedWebsockets);
    }

    public static HttpMaidBuilder anHttpMaid() {
        return HttpMaidBuilder.httpMaidBuilder();
    }

    @Override
    public void close() {
        ClosingActions closingActions = this.chainRegistry.getMetaDatum(ClosingActions.CLOSING_ACTIONS);
        closingActions.closeAll();
    }

    @Generated
    private HttpMaid(ChainRegistry chainRegistry) {
        this.chainRegistry = chainRegistry;
    }
}

