/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid;

import de.quantummaid.httpmaid.CoreModule;
import de.quantummaid.httpmaid.HttpConfiguration;
import de.quantummaid.httpmaid.HttpMaid;
import de.quantummaid.httpmaid.PerRouteConfigurator;
import de.quantummaid.httpmaid.chains.ChainRegistry;
import de.quantummaid.httpmaid.chains.ChainRegistryBuilder;
import de.quantummaid.httpmaid.chains.Configurator;
import de.quantummaid.httpmaid.generator.GenerationCondition;
import de.quantummaid.httpmaid.generator.builder.ConditionStage;
import de.quantummaid.httpmaid.handler.http.HttpHandler;
import de.quantummaid.httpmaid.startupchecks.StartupChecks;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.WebsocketRoute;
import de.quantummaid.httpmaid.websockets.WebsocketsModule;
import de.quantummaid.httpmaid.websockets.broadcast.BroadcasterFactory;
import de.quantummaid.httpmaid.websockets.broadcast.Broadcasters;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenders;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

public final class HttpMaidBuilder
implements HttpConfiguration<HttpMaidBuilder> {
    private boolean autodetectionOfModules = true;
    private boolean performStartupChecks = true;
    private final CoreModule coreModule;
    private final List<Configurator> configurators;
    private final Broadcasters broadcasters = Broadcasters.broadcasters();

    static HttpMaidBuilder httpMaidBuilder() {
        return new HttpMaidBuilder(CoreModule.coreModule(), new ArrayList<Configurator>());
    }

    public HttpMaidBuilder disableAutodectectionOfModules() {
        this.autodetectionOfModules = false;
        return this;
    }

    public HttpMaidBuilder disableStartupChecks() {
        this.performStartupChecks = false;
        return this;
    }

    @Override
    public ConditionStage<HttpMaidBuilder> serving(Object handler, PerRouteConfigurator ... perRouteConfigurators) {
        Validators.validateNotNull(handler, "handler");
        return condition -> {
            this.coreModule.registerHandler(condition, handler, Arrays.asList(perRouteConfigurators));
            return this;
        };
    }

    public HttpMaidBuilder websocket(String id, HttpHandler handler) {
        return this.websocket(id, (Object)handler);
    }

    public HttpMaidBuilder websocket(String id, Object handler) {
        Validators.validateNotNull(id, "id");
        Validators.validateNotNull(handler, "handler");
        GenerationCondition condition = WebsocketRoute.webSocketCategory(id);
        return this.serving(handler, new PerRouteConfigurator[0]).when(condition);
    }

    public <T, U> HttpMaidBuilder broadcast(Class<T> broadcaster, Class<U> messageType, BroadcasterFactory<T, U> factory) {
        this.broadcasters.addBroadcaster(broadcaster, messageType, factory);
        return this;
    }

    @Override
    public HttpMaidBuilder configured(Configurator configurator) {
        Validators.validateNotNull(configurator, "configurator");
        this.configurators.add(configurator);
        return this;
    }

    public HttpMaid build() {
        Instant begin = Instant.now();
        ChainRegistryBuilder chainRegistryBuilder = ChainRegistryBuilder.chainRegistryBuilder();
        chainRegistryBuilder.addMetaDatum(Broadcasters.BROADCASTERS, this.broadcasters);
        chainRegistryBuilder.addMetaDatum(WebsocketSenders.WEBSOCKET_SENDERS, WebsocketSenders.websocketSenders());
        chainRegistryBuilder.addModule(this.coreModule);
        chainRegistryBuilder.addModule(WebsocketsModule.websocketsModule());
        if (this.autodetectionOfModules) {
            chainRegistryBuilder.addModuleIfPresent("de.quantummaid.httpmaid.events.EventModule");
            chainRegistryBuilder.addModuleIfPresent("de.quantummaid.httpmaid.usecases.UseCasesModule");
            chainRegistryBuilder.addModuleIfPresent("de.quantummaid.httpmaid.mapmaid.MapMaidModule");
        }
        this.configurators.forEach(chainRegistryBuilder::addConfigurator);
        ChainRegistry chainRegistry = chainRegistryBuilder.build();
        HttpMaid httpMaid = HttpMaid.httpMaid(chainRegistry);
        Instant end = Instant.now();
        Duration startUpTime = Duration.between(begin, end);
        if (this.performStartupChecks) {
            StartupChecks startupChecks = chainRegistry.getMetaDatum(StartupChecks.STARTUP_CHECKS);
            startupChecks.check();
        }
        chainRegistry.addMetaDatum(HttpMaid.STARTUP_TIME, startUpTime);
        return httpMaid;
    }

    @Generated
    public String toString() {
        return "HttpMaidBuilder(autodetectionOfModules=" + this.autodetectionOfModules + ", performStartupChecks=" + this.performStartupChecks + ", coreModule=" + this.coreModule + ", configurators=" + this.configurators + ", broadcasters=" + this.broadcasters + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpMaidBuilder)) {
            return false;
        }
        HttpMaidBuilder other = (HttpMaidBuilder)o;
        if (this.autodetectionOfModules != other.autodetectionOfModules) {
            return false;
        }
        if (this.performStartupChecks != other.performStartupChecks) {
            return false;
        }
        CoreModule this$coreModule = this.coreModule;
        CoreModule other$coreModule = other.coreModule;
        if (this$coreModule == null ? other$coreModule != null : !((Object)this$coreModule).equals(other$coreModule)) {
            return false;
        }
        List<Configurator> this$configurators = this.configurators;
        List<Configurator> other$configurators = other.configurators;
        if (this$configurators == null ? other$configurators != null : !((Object)this$configurators).equals(other$configurators)) {
            return false;
        }
        Broadcasters this$broadcasters = this.broadcasters;
        Broadcasters other$broadcasters = other.broadcasters;
        return !(this$broadcasters == null ? other$broadcasters != null : !((Object)this$broadcasters).equals(other$broadcasters));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.autodetectionOfModules ? 79 : 97);
        result = result * 59 + (this.performStartupChecks ? 79 : 97);
        CoreModule $coreModule = this.coreModule;
        result = result * 59 + ($coreModule == null ? 43 : ((Object)$coreModule).hashCode());
        List<Configurator> $configurators = this.configurators;
        result = result * 59 + ($configurators == null ? 43 : ((Object)$configurators).hashCode());
        Broadcasters $broadcasters = this.broadcasters;
        result = result * 59 + ($broadcasters == null ? 43 : ((Object)$broadcasters).hashCode());
        return result;
    }

    @Generated
    private HttpMaidBuilder(CoreModule coreModule, List<Configurator> configurators) {
        this.coreModule = coreModule;
        this.configurators = configurators;
    }
}

