/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.broadcast;

import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.MetaDataKey;
import de.quantummaid.httpmaid.websockets.WebsocketMetaDataKeys;
import de.quantummaid.httpmaid.websockets.broadcast.BroadcasterFactory;
import de.quantummaid.httpmaid.websockets.broadcast.SerializingSender;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistry;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenders;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public final class Broadcasters {
    public static final MetaDataKey<Broadcasters> BROADCASTERS = MetaDataKey.metaDataKey("BROADCASTERS");
    private final Map<Class<?>, BroadcasterFactory<?, Object>> factories = new HashMap();
    private final List<Class<?>> messageTypes = new ArrayList();

    public static Broadcasters broadcasters() {
        return new Broadcasters();
    }

    public <T, U> void addBroadcaster(Class<T> type, Class<U> messageType, BroadcasterFactory<T, U> factory) {
        this.factories.put(type, factory);
        this.messageTypes.add(messageType);
    }

    public Collection<Class<?>> injectionTypes() {
        return this.factories.keySet();
    }

    public List<Object> instantiateAll(MetaData metaData) {
        WebsocketSenders websocketSenders = metaData.get(WebsocketSenders.WEBSOCKET_SENDERS);
        WebsocketRegistry websocketRegistry = metaData.get(WebsocketMetaDataKeys.WEBSOCKET_REGISTRY);
        SerializingSender serializingSender = SerializingSender.serializingSender(websocketRegistry, websocketSenders);
        return this.factories.values().stream().map(broadcasterFactory -> broadcasterFactory.createBroadcaster(serializingSender)).collect(Collectors.toList());
    }

    @Generated
    public String toString() {
        return "Broadcasters(factories=" + this.factories + ", messageTypes=" + this.messageTypes + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Broadcasters)) {
            return false;
        }
        Broadcasters other = (Broadcasters)o;
        Map<Class<?>, BroadcasterFactory<?, Object>> this$factories = this.factories;
        Map<Class<?>, BroadcasterFactory<?, Object>> other$factories = other.factories;
        if (this$factories == null ? other$factories != null : !((Object)this$factories).equals(other$factories)) {
            return false;
        }
        List<Class<?>> this$messageTypes = this.messageTypes;
        List<Class<?>> other$messageTypes = other.messageTypes;
        return !(this$messageTypes == null ? other$messageTypes != null : !((Object)this$messageTypes).equals(other$messageTypes));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Class<?>, BroadcasterFactory<?, Object>> $factories = this.factories;
        result = result * 59 + ($factories == null ? 43 : ((Object)$factories).hashCode());
        List<Class<?>> $messageTypes = this.messageTypes;
        result = result * 59 + ($messageTypes == null ? 43 : ((Object)$messageTypes).hashCode());
        return result;
    }

    @Generated
    private Broadcasters() {
    }
}

