/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.cors.domain;

import de.quantummaid.httpmaid.util.Validators;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class RequestedHeader {
    private static final List<RequestedHeader> SIMPLE_REQUEST_HEADERS = Stream.of("Accept", "Accept-Language", "Content-Language").map(RequestedHeader::requestedHeader).collect(Collectors.toList());
    private final String name;

    public static RequestedHeader requestedHeader(String name) {
        Validators.validateNotNullNorEmpty(name, "name");
        String normalized = name.toLowerCase();
        return new RequestedHeader(normalized);
    }

    public boolean isSimpleHeader() {
        return SIMPLE_REQUEST_HEADERS.contains(this);
    }

    public String internalValueForMapping() {
        return this.name;
    }

    public String toString() {
        return "RequestedHeader(name=" + this.name + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestedHeader)) {
            return false;
        }
        RequestedHeader other = (RequestedHeader)o;
        String this$name = this.name;
        String other$name = other.name;
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    private RequestedHeader(String name) {
        this.name = name;
    }
}

