/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.handler.http.files;

import de.quantummaid.httpmaid.handler.http.files.FileDoesNotExistException;
import de.quantummaid.httpmaid.handler.http.files.MultiformatPath;
import de.quantummaid.httpmaid.util.Validators;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;

public final class FileLoader {
    private FileLoader() {
    }

    public static InputStream loadFile(File file) {
        Validators.validateNotNull(file, "file");
        try {
            return new FileInputStream(file);
        }
        catch (IOException e) {
            throw FileDoesNotExistException.filesystemFileDoesNotExistException(file.getAbsolutePath(), e);
        }
    }

    public static InputStream loadJavaResource(MultiformatPath path) {
        String properlyFormatted;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        URL resource = contextClassLoader.getResource(properlyFormatted = path.formatted("", ""));
        if (Objects.isNull(resource) || FileLoader.isDirectory(contextClassLoader, path, resource)) {
            throw FileDoesNotExistException.javaResourceDoesNotExistException(path);
        }
        try {
            return resource.openStream();
        }
        catch (IOException e) {
            throw FileDoesNotExistException.javaResourceDoesNotExistException(path, e);
        }
    }

    private static boolean isDirectory(ClassLoader classLoader, MultiformatPath path, URL properlyLoadedResource) {
        Validators.validateNotNull(properlyLoadedResource, "properlyLoadedResource");
        String protocol = properlyLoadedResource.getProtocol();
        if ("file".equals(protocol)) {
            File file = new File(properlyLoadedResource.getPath());
            return file.isDirectory();
        }
        if ("jar".equals(protocol)) {
            String asDirectoryPath = path.formatted("", "/");
            URL asDirectoryLoadedResources = classLoader.getResource(asDirectoryPath);
            return Objects.nonNull(asDirectoryLoadedResources);
        }
        throw new UnsupportedOperationException(String.format("Not able to load resource '%s' because protocol '%s' is not supported", path, protocol));
    }
}

