/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.logger;

import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.logger.LogLevel;
import de.quantummaid.httpmaid.util.Validators;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import java.util.StringJoiner;

public final class LogMessage {
    private final String message;
    private final Throwable throwable;
    private final LogLevel logLevel;
    private final MetaData metaData;

    public static LogMessage logMessage(String message, Throwable throwable, LogLevel logLevel, MetaData metaData) {
        Validators.validateNotNull(logLevel, "logLevel");
        Validators.validateNotNull(metaData, "metaData");
        return new LogMessage(message, throwable, logLevel, metaData);
    }

    public boolean hasMessage() {
        return this.message().isPresent();
    }

    public Optional<String> message() {
        return Optional.ofNullable(this.message);
    }

    public boolean hasException() {
        return this.exception().isPresent();
    }

    public Optional<Throwable> exception() {
        return Optional.ofNullable(this.throwable);
    }

    public Optional<String> stacktraceOfException() {
        return this.exception().map(LogMessage::stackTraceToString);
    }

    public String formattedMessage() {
        String prefix = this.logLevel.asString() + ": ";
        StringJoiner joiner = new StringJoiner("\n", prefix, "");
        this.message().ifPresent(joiner::add);
        this.stacktraceOfException().ifPresent(joiner::add);
        return joiner.toString();
    }

    public LogLevel logLevel() {
        return this.logLevel;
    }

    public MetaData metaData() {
        return this.metaData;
    }

    private static String stackTraceToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    public String toString() {
        return "LogMessage(message=" + this.message + ", throwable=" + this.throwable + ", logLevel=" + this.logLevel + ", metaData=" + this.metaData + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogMessage)) {
            return false;
        }
        LogMessage other = (LogMessage)o;
        String this$message = this.message;
        String other$message = other.message;
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Throwable this$throwable = this.throwable;
        Throwable other$throwable = other.throwable;
        if (this$throwable == null ? other$throwable != null : !this$throwable.equals(other$throwable)) {
            return false;
        }
        LogLevel this$logLevel = this.logLevel;
        LogLevel other$logLevel = other.logLevel;
        if (this$logLevel == null ? other$logLevel != null : !((Object)this$logLevel).equals(other$logLevel)) {
            return false;
        }
        MetaData this$metaData = this.metaData;
        MetaData other$metaData = other.metaData;
        return !(this$metaData == null ? other$metaData != null : !((Object)this$metaData).equals(other$metaData));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $message = this.message;
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Throwable $throwable = this.throwable;
        result = result * 59 + ($throwable == null ? 43 : $throwable.hashCode());
        LogLevel $logLevel = this.logLevel;
        result = result * 59 + ($logLevel == null ? 43 : ((Object)$logLevel).hashCode());
        MetaData $metaData = this.metaData;
        result = result * 59 + ($metaData == null ? 43 : ((Object)$metaData).hashCode());
        return result;
    }

    private LogMessage(String message, Throwable throwable, LogLevel logLevel, MetaData metaData) {
        this.message = message;
        this.throwable = throwable;
        this.logLevel = logLevel;
        this.metaData = metaData;
    }
}

