/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.marshalling;

import de.quantummaid.httpmaid.http.headers.ContentType;
import de.quantummaid.httpmaid.marshalling.Marshaller;
import de.quantummaid.httpmaid.marshalling.MarshallingModuleConfigurator;
import de.quantummaid.httpmaid.marshalling.Unmarshaller;
import de.quantummaid.httpmaid.marshalling.urlencoded.UrlEncodedUnmarshaller;
import de.quantummaid.httpmaid.util.Validators;

public final class MarshallingConfigurators {
    private MarshallingConfigurators() {
    }

    public static MarshallingModuleConfigurator toUnmarshallFormUrlEncodedRequests() {
        return MarshallingConfigurators.toUnmarshallContentTypeInRequests(ContentType.formUrlEncoded(), UrlEncodedUnmarshaller.urlEncodedUnmarshaller());
    }

    public static MarshallingModuleConfigurator toMarshallContentType(ContentType contentType, Unmarshaller unmarshaller, Marshaller marshaller) {
        Validators.validateNotNull(contentType, "contentType");
        Validators.validateNotNull(unmarshaller, "unmarshaller");
        Validators.validateNotNull(marshaller, "marshaller");
        return marshallingModule -> {
            marshallingModule.addUnmarshaller(contentType, unmarshaller);
            marshallingModule.addMarshaller(contentType, marshaller);
        };
    }

    public static MarshallingModuleConfigurator toUnmarshallContentTypeInRequests(ContentType contentType, Unmarshaller unmarshaller) {
        Validators.validateNotNull(contentType, "contentType");
        Validators.validateNotNull(unmarshaller, "unmarshaller");
        return marshallingModule -> marshallingModule.addUnmarshaller(contentType, unmarshaller);
    }

    public static MarshallingModuleConfigurator toMarshallContentTypeInResponses(ContentType contentType, Marshaller marshaller) {
        Validators.validateNotNull(contentType, "contentType");
        Validators.validateNotNull(marshaller, "marshaller");
        return marshallingModule -> marshallingModule.addMarshaller(contentType, marshaller);
    }

    public static MarshallingModuleConfigurator toMarshallByDefaultUsingTheContentType(ContentType contentType) {
        Validators.validateNotNull(contentType, "contentType");
        return marshallingModule -> marshallingModule.setDefaultContentType(contentType);
    }

    public static MarshallingModuleConfigurator toThrowAnExceptionIfNoMarshallerWasFound() {
        return marshallingModule -> marshallingModule.setThrowExceptionIfNoMarshallerFound(true);
    }
}

