/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.broadcast;

import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.MetaDataKey;
import de.quantummaid.httpmaid.websockets.WebsocketMetaDataKeys;
import de.quantummaid.httpmaid.websockets.broadcast.BroadcasterFactory;
import de.quantummaid.httpmaid.websockets.broadcast.SerializingSender;
import de.quantummaid.httpmaid.websockets.disconnect.Disconnector;
import de.quantummaid.httpmaid.websockets.disconnect.DisconnectorFactory;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistry;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenders;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public final class Broadcasters {
    public static final MetaDataKey<Broadcasters> BROADCASTERS = MetaDataKey.metaDataKey("BROADCASTERS");
    private final Map<Class<?>, BroadcasterFactory<?, Object>> broadcasterFactories = new LinkedHashMap();
    private final List<Class<?>> messageTypes = new ArrayList();
    private final Map<Class<?>, DisconnectorFactory<?>> disconnectorFactories = new LinkedHashMap();

    public static Broadcasters broadcasters() {
        return new Broadcasters();
    }

    public <T, U> void addBroadcaster(Class<T> type, Class<U> messageType, BroadcasterFactory<T, U> factory) {
        this.broadcasterFactories.put(type, factory);
        this.messageTypes.add(messageType);
    }

    public <T> void addDisconnector(Class<T> type, DisconnectorFactory<T> factory) {
        this.disconnectorFactories.put(type, factory);
    }

    public Collection<Class<?>> injectionTypes() {
        ArrayList injectionTypes = new ArrayList();
        injectionTypes.addAll(this.broadcasterFactories.keySet());
        injectionTypes.addAll(this.disconnectorFactories.keySet());
        return injectionTypes;
    }

    public List<Object> instantiateAll(MetaData metaData) {
        WebsocketSenders websocketSenders = metaData.get(WebsocketSenders.WEBSOCKET_SENDERS);
        WebsocketRegistry websocketRegistry = metaData.get(WebsocketMetaDataKeys.WEBSOCKET_REGISTRY);
        SerializingSender serializingSender = SerializingSender.serializingSender(websocketRegistry, websocketSenders);
        ArrayList<Object> instances = new ArrayList<Object>();
        this.broadcasterFactories.values().stream().map(broadcasterFactory -> broadcasterFactory.createBroadcaster(serializingSender)).forEach(instances::add);
        Disconnector disconnector = Disconnector.disconnector(websocketRegistry, websocketSenders);
        this.disconnectorFactories.values().stream().map(disconnectorFactory -> disconnectorFactory.createDisconnector(disconnector)).forEach(instances::add);
        return instances;
    }

    @Generated
    public String toString() {
        return "Broadcasters(broadcasterFactories=" + this.broadcasterFactories + ", messageTypes=" + this.messageTypes + ", disconnectorFactories=" + this.disconnectorFactories + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Broadcasters)) {
            return false;
        }
        Broadcasters other = (Broadcasters)o;
        Map<Class<?>, BroadcasterFactory<?, Object>> this$broadcasterFactories = this.broadcasterFactories;
        Map<Class<?>, BroadcasterFactory<?, Object>> other$broadcasterFactories = other.broadcasterFactories;
        if (this$broadcasterFactories == null ? other$broadcasterFactories != null : !((Object)this$broadcasterFactories).equals(other$broadcasterFactories)) {
            return false;
        }
        List<Class<?>> this$messageTypes = this.messageTypes;
        List<Class<?>> other$messageTypes = other.messageTypes;
        if (this$messageTypes == null ? other$messageTypes != null : !((Object)this$messageTypes).equals(other$messageTypes)) {
            return false;
        }
        Map<Class<?>, DisconnectorFactory<?>> this$disconnectorFactories = this.disconnectorFactories;
        Map<Class<?>, DisconnectorFactory<?>> other$disconnectorFactories = other.disconnectorFactories;
        return !(this$disconnectorFactories == null ? other$disconnectorFactories != null : !((Object)this$disconnectorFactories).equals(other$disconnectorFactories));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Class<?>, BroadcasterFactory<?, Object>> $broadcasterFactories = this.broadcasterFactories;
        result = result * 59 + ($broadcasterFactories == null ? 43 : ((Object)$broadcasterFactories).hashCode());
        List<Class<?>> $messageTypes = this.messageTypes;
        result = result * 59 + ($messageTypes == null ? 43 : ((Object)$messageTypes).hashCode());
        Map<Class<?>, DisconnectorFactory<?>> $disconnectorFactories = this.disconnectorFactories;
        result = result * 59 + ($disconnectorFactories == null ? 43 : ((Object)$disconnectorFactories).hashCode());
        return result;
    }

    @Generated
    private Broadcasters() {
    }
}

