/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.broadcast;

import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.criteria.WebsocketCriteria;
import de.quantummaid.httpmaid.websockets.registry.ConnectionInformation;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistry;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistryEntry;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSender;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenderId;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenders;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SerializingSender<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SerializingSender.class);
    private final WebsocketRegistry websocketRegistry;
    private final WebsocketSenders websocketSenders;

    public static <T> SerializingSender<T> serializingSender(WebsocketRegistry websocketRegistry, WebsocketSenders websocketSenders) {
        return new SerializingSender<T>(websocketRegistry, websocketSenders);
    }

    public void sendToAll(T message) {
        this.sendTo(message, WebsocketCriteria.websocketCriteria());
    }

    public void sendTo(T message, WebsocketCriteria criteria) {
        Validators.validateNotNull(message, "message");
        Validators.validateNotNull(criteria, "criteria");
        List<WebsocketRegistryEntry> connections = this.websocketRegistry.connections(criteria);
        Map<WebsocketSenderId, List<WebsocketRegistryEntry>> bySenderId = connections.stream().collect(Collectors.groupingBy(WebsocketRegistryEntry::getSenderId));
        bySenderId.forEach((websocketSenderId, websocketRegistryEntries) -> {
            List collectionInformations = websocketRegistryEntries.stream().map(WebsocketRegistryEntry::connectionInformation).collect(Collectors.toList());
            WebsocketSender<ConnectionInformation> sender = this.websocketSenders.senderById((WebsocketSenderId)websocketSenderId);
            sender.send((String)message, collectionInformations, (connectionInformation, throwable) -> {
                log.info("Exception when sending to websocket {}. Removing websocket.", connectionInformation, throwable);
                this.websocketRegistry.removeConnection((ConnectionInformation)connectionInformation);
            });
        });
    }

    @Generated
    public String toString() {
        return "SerializingSender(websocketRegistry=" + this.websocketRegistry + ", websocketSenders=" + this.websocketSenders + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SerializingSender)) {
            return false;
        }
        SerializingSender other = (SerializingSender)o;
        WebsocketRegistry this$websocketRegistry = this.websocketRegistry;
        WebsocketRegistry other$websocketRegistry = other.websocketRegistry;
        if (this$websocketRegistry == null ? other$websocketRegistry != null : !this$websocketRegistry.equals(other$websocketRegistry)) {
            return false;
        }
        WebsocketSenders this$websocketSenders = this.websocketSenders;
        WebsocketSenders other$websocketSenders = other.websocketSenders;
        return !(this$websocketSenders == null ? other$websocketSenders != null : !((Object)this$websocketSenders).equals(other$websocketSenders));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WebsocketRegistry $websocketRegistry = this.websocketRegistry;
        result = result * 59 + ($websocketRegistry == null ? 43 : $websocketRegistry.hashCode());
        WebsocketSenders $websocketSenders = this.websocketSenders;
        result = result * 59 + ($websocketSenders == null ? 43 : ((Object)$websocketSenders).hashCode());
        return result;
    }

    @Generated
    private SerializingSender(WebsocketRegistry websocketRegistry, WebsocketSenders websocketSenders) {
        this.websocketRegistry = websocketRegistry;
        this.websocketSenders = websocketSenders;
    }
}

