/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.handler.http;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.http.Headers;
import de.quantummaid.httpmaid.http.HttpRequestMethod;
import de.quantummaid.httpmaid.http.PathParameters;
import de.quantummaid.httpmaid.http.QueryParameters;
import de.quantummaid.httpmaid.http.headers.ContentType;
import de.quantummaid.httpmaid.http.headers.cookies.Cookies;
import de.quantummaid.httpmaid.path.Path;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.WebsocketMetaDataKeys;
import de.quantummaid.httpmaid.websockets.Websockets;
import de.quantummaid.httpmaid.websockets.broadcast.NonSerializingSender;
import de.quantummaid.httpmaid.websockets.disconnect.Disconnector;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistry;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenders;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public final class HttpRequest {
    private final MetaData metaData;

    public static HttpRequest httpRequest(MetaData metaData) {
        Validators.validateNotNull(metaData, "metaData");
        return new HttpRequest(metaData);
    }

    public HttpRequestMethod method() {
        return this.metaData.get(HttpMaidChainKeys.METHOD);
    }

    public Path path() {
        return this.metaData.get(HttpMaidChainKeys.PATH);
    }

    public PathParameters pathParameters() {
        return this.metaData.get(HttpMaidChainKeys.PATH_PARAMETERS);
    }

    public QueryParameters queryParameters() {
        return this.metaData.get(HttpMaidChainKeys.QUERY_PARAMETERS);
    }

    public Headers headers() {
        return this.metaData.get(HttpMaidChainKeys.REQUEST_HEADERS);
    }

    public Cookies cookies() {
        return Cookies.cookiesFromHeaders(this.headers());
    }

    public ContentType contentType() {
        return this.optionalContentType().orElseThrow(() -> new RuntimeException(String.format("Request does not have a content type.%n%n%s", this.metaData.prettyPrint())));
    }

    public Optional<ContentType> optionalContentType() {
        return this.metaData.getOptional(HttpMaidChainKeys.REQUEST_CONTENT_TYPE);
    }

    public Optional<String> optionalBodyString() {
        return this.metaData.getOptional(HttpMaidChainKeys.REQUEST_BODY_STRING);
    }

    public String bodyString() {
        return this.optionalBodyString().orElseThrow(() -> new RuntimeException("Request does not have a body"));
    }

    public <T> T authenticationInformationAs(Class<T> type) {
        return (T)this.metaData.getOptionalAs(HttpMaidChainKeys.AUTHENTICATION_INFORMATION, type).orElseThrow(() -> new RuntimeException("Request is not authenticated"));
    }

    public Object authenticationInformation() {
        return this.optionalAuthenticationInformation().orElseThrow(() -> new RuntimeException("Request is not authenticated"));
    }

    public Optional<Object> optionalAuthenticationInformation() {
        return this.metaData.getOptional(HttpMaidChainKeys.AUTHENTICATION_INFORMATION);
    }

    public <T> Optional<T> optionalAuthenticationInformationAs(Class<T> type) {
        Validators.validateNotNull(type, "type");
        return this.optionalAuthenticationInformation();
    }

    public Map<String, Object> bodyMap() {
        return this.optionalBodyMap().orElseThrow(() -> new RuntimeException(String.format("Request does not have a body map.%n%n%s", this.metaData.prettyPrint())));
    }

    public Optional<Map<String, Object>> optionalBodyMap() {
        return this.metaData.getOptional(HttpMaidChainKeys.UNMARSHALLED_REQUEST_BODY).flatMap(unmarshalled -> {
            if (unmarshalled instanceof Map) {
                return Optional.of((Map)unmarshalled);
            }
            return Optional.empty();
        });
    }

    public Websockets websockets() {
        WebsocketSenders websocketSenders = this.metaData.get(WebsocketSenders.WEBSOCKET_SENDERS);
        WebsocketRegistry websocketRegistry = this.metaData.get(WebsocketMetaDataKeys.WEBSOCKET_REGISTRY);
        NonSerializingSender sender = NonSerializingSender.nonSerializingSender(websocketRegistry, websocketSenders);
        Disconnector disconnector = Disconnector.disconnector(websocketRegistry, websocketSenders);
        return Websockets.websockets(sender, disconnector);
    }

    @Generated
    public MetaData getMetaData() {
        return this.metaData;
    }

    @Generated
    public String toString() {
        return "HttpRequest(metaData=" + this.getMetaData() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpRequest)) {
            return false;
        }
        HttpRequest other = (HttpRequest)o;
        MetaData this$metaData = this.getMetaData();
        MetaData other$metaData = other.getMetaData();
        return !(this$metaData == null ? other$metaData != null : !((Object)this$metaData).equals(other$metaData));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MetaData $metaData = this.getMetaData();
        result = result * 59 + ($metaData == null ? 43 : ((Object)$metaData).hashCode());
        return result;
    }

    @Generated
    private HttpRequest(MetaData metaData) {
        this.metaData = metaData;
    }
}

