/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.chains;

import de.quantummaid.httpmaid.MetricsProvider;
import de.quantummaid.httpmaid.chains.ChainModule;
import de.quantummaid.httpmaid.chains.ChainRegistry;
import de.quantummaid.httpmaid.chains.IndexedModules;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.MetaDataKey;
import de.quantummaid.httpmaid.util.Validators;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public final class DependencyRegistry {
    private final IndexedModules modules;
    private final MetaData metaData;

    static DependencyRegistry load(List<ChainModule> modules, MetaData metaData) {
        Validators.validateNotNull(modules, "modules");
        Validators.validateNotNull(metaData, "metaData");
        return new DependencyRegistry(IndexedModules.indexedModules(modules), metaData);
    }

    public <T extends ChainModule> T getDependency(Class<T> dependency) {
        Validators.validateNotNull(dependency, "dependency");
        return this.modules.get(dependency);
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public <T> void setMetaDatum(MetaDataKey<T> key, T value) {
        this.metaData.set(key, value);
    }

    public <T> T getMetaDatum(MetaDataKey<T> key) {
        return this.metaData.get(key);
    }

    public <T> MetricsProvider<T> createMetricsProvider(MetaDataKey<T> key, T defaultValue) {
        Validators.validateNotNull(key, "key");
        Validators.validateNotNull(defaultValue, "defaultValue");
        this.metaData.set(key, defaultValue);
        return MetricsProvider.metricsProvider(key, this.metaData);
    }

    IndexedModules modules() {
        return this.modules;
    }

    List<ChainModule> addIfNotAlreadyPresentAndReturnFollowUpDependencies(ChainModule module) {
        Validators.validateNotNull(module, "module");
        Class<?> key = module.getClass();
        if (this.modules.contains(key)) {
            return Collections.emptyList();
        }
        this.modules.add(module);
        return module.supplyModulesIfNotAlreadyPresent();
    }

    ChainRegistry buildChainRegistry() {
        ChainRegistry chainRegistry = ChainRegistry.emptyChainRegistry(this.metaData);
        this.modules.stream().forEach(chainRegistry::extend);
        return chainRegistry;
    }

    @Generated
    public String toString() {
        return "DependencyRegistry(modules=" + this.modules + ", metaData=" + this.getMetaData() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DependencyRegistry)) {
            return false;
        }
        DependencyRegistry other = (DependencyRegistry)o;
        IndexedModules this$modules = this.modules;
        IndexedModules other$modules = other.modules;
        if (this$modules == null ? other$modules != null : !((Object)this$modules).equals(other$modules)) {
            return false;
        }
        MetaData this$metaData = this.getMetaData();
        MetaData other$metaData = other.getMetaData();
        return !(this$metaData == null ? other$metaData != null : !((Object)this$metaData).equals(other$metaData));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IndexedModules $modules = this.modules;
        result = result * 59 + ($modules == null ? 43 : ((Object)$modules).hashCode());
        MetaData $metaData = this.getMetaData();
        result = result * 59 + ($metaData == null ? 43 : ((Object)$metaData).hashCode());
        return result;
    }

    @Generated
    private DependencyRegistry(IndexedModules modules, MetaData metaData) {
        this.modules = modules;
        this.metaData = metaData;
    }
}

