/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.chains.graph;

import de.quantummaid.httpmaid.chains.graph.Color;
import de.quantummaid.httpmaid.util.Validators;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public final class ColorPool<T> {
    private final List<Color> remainingColors;
    private final Map<T, Color> assignedColors;

    public static <T> ColorPool<T> colorPool() {
        List<Color> availableColors = Arrays.asList(Color.BLACK, Color.ORANGE, Color.GREEN, Color.BLUE, Color.VIOLET, Color.PURPLE, Color.YELLOW);
        return new ColorPool(new LinkedList<Color>(availableColors), new HashMap());
    }

    public Color assign(T key) {
        Validators.validateNotNull(key, "key");
        if (this.assignedColors.containsKey(key)) {
            return this.assignedColors.get(key);
        }
        Color nextColor = this.remainingColors.get(0);
        this.remainingColors.remove(0);
        this.assignedColors.put(key, nextColor);
        return nextColor;
    }

    @Generated
    public String toString() {
        return "ColorPool(remainingColors=" + this.remainingColors + ", assignedColors=" + this.assignedColors + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColorPool)) {
            return false;
        }
        ColorPool other = (ColorPool)o;
        List<Color> this$remainingColors = this.remainingColors;
        List<Color> other$remainingColors = other.remainingColors;
        if (this$remainingColors == null ? other$remainingColors != null : !((Object)this$remainingColors).equals(other$remainingColors)) {
            return false;
        }
        Map<T, Color> this$assignedColors = this.assignedColors;
        Map<T, Color> other$assignedColors = other.assignedColors;
        return !(this$assignedColors == null ? other$assignedColors != null : !((Object)this$assignedColors).equals(other$assignedColors));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Color> $remainingColors = this.remainingColors;
        result = result * 59 + ($remainingColors == null ? 43 : ((Object)$remainingColors).hashCode());
        Map<T, Color> $assignedColors = this.assignedColors;
        result = result * 59 + ($assignedColors == null ? 43 : ((Object)$assignedColors).hashCode());
        return result;
    }

    @Generated
    private ColorPool(List<Color> remainingColors, Map<T, Color> assignedColors) {
        this.remainingColors = remainingColors;
        this.assignedColors = assignedColors;
    }
}

