/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.http;

import de.quantummaid.httpmaid.http.Header;
import de.quantummaid.httpmaid.http.HeaderName;
import de.quantummaid.httpmaid.http.HeaderValue;
import de.quantummaid.httpmaid.http.HttpRequestException;
import de.quantummaid.httpmaid.util.Validators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public final class Headers {
    private final List<Header> headers;

    public static Headers headers(List<Header> headers) {
        Validators.validateNotNull(headers, "headers");
        return new Headers(headers);
    }

    public List<String> allValuesFor(String name) {
        HeaderName headerName = HeaderName.headerName(name);
        return this.headers.stream().filter(header -> headerName.equals(header.name())).map(Header::value).map(HeaderValue::stringValue).collect(Collectors.toList());
    }

    public Optional<String> optionalHeader(String name) {
        List<String> values = this.allValuesFor(name);
        if (values.isEmpty()) {
            return Optional.empty();
        }
        if (values.size() > 1) {
            String joinedValues = String.join((CharSequence)", ", values);
            throw HttpRequestException.httpHandlerException(String.format("Expecting header '%s' to only have one value but got [%s]", name, joinedValues));
        }
        return Optional.of(values.get(0));
    }

    public String header(String name) {
        return this.optionalHeader(name).orElseThrow(() -> HttpRequestException.httpHandlerException(String.format("No header with name '%s'", name)));
    }

    public List<Header> asList() {
        return Collections.unmodifiableList(this.headers);
    }

    public Map<String, List<String>> asMap() {
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        this.headers.forEach(header -> {
            String name = header.name().stringValue();
            String value = header.value().stringValue();
            List values = result.getOrDefault(name, new ArrayList());
            values.add(value);
            result.put(name, values);
        });
        return result;
    }

    @Generated
    public String toString() {
        return "Headers(headers=" + this.headers + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Headers)) {
            return false;
        }
        Headers other = (Headers)o;
        List<Header> this$headers = this.headers;
        List<Header> other$headers = other.headers;
        return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Header> $headers = this.headers;
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        return result;
    }

    @Generated
    private Headers(List<Header> headers) {
        this.headers = headers;
    }
}

