/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.processors;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.http.HttpRequestMethod;
import de.quantummaid.httpmaid.http.headers.ContentType;
import de.quantummaid.httpmaid.path.Path;
import java.util.Optional;
import lombok.Generated;

public final class TranslateToValueObjectsProcessor
implements Processor {
    public static Processor translateToValueObjectsProcessor() {
        return new TranslateToValueObjectsProcessor();
    }

    @Override
    public void apply(MetaData metaData) {
        metaData.getOptional(HttpMaidChainKeys.REQUEST_HEADERS).ifPresentOrElse(headers -> {
            Optional<String> optionalContentType = headers.optionalHeader("Content-Type");
            ContentType contentType = ContentType.fromString(optionalContentType);
            metaData.set(HttpMaidChainKeys.REQUEST_CONTENT_TYPE, contentType);
        }, () -> metaData.set(HttpMaidChainKeys.REQUEST_CONTENT_TYPE, ContentType.fromString(Optional.empty())));
        metaData.getOptional(HttpMaidChainKeys.RAW_METHOD).ifPresent(rawMethod -> metaData.set(HttpMaidChainKeys.METHOD, HttpRequestMethod.parse(rawMethod)));
        metaData.getOptional(HttpMaidChainKeys.RAW_PATH).ifPresent(rawPath -> metaData.set(HttpMaidChainKeys.PATH, Path.path(rawPath)));
    }

    @Generated
    public String toString() {
        return "TranslateToValueObjectsProcessor()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof TranslateToValueObjectsProcessor;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    private TranslateToValueObjectsProcessor() {
    }
}

