/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.logger;

import de.quantummaid.httpmaid.CoreModule;
import de.quantummaid.httpmaid.chains.Configurator;
import de.quantummaid.httpmaid.logger.LoggerImplementation;
import de.quantummaid.httpmaid.logger.Loggers;
import de.quantummaid.httpmaid.util.Validators;

public final class LoggerConfigurators {
    private LoggerConfigurators() {
    }

    public static Configurator toLogUsing(LoggerImplementation logger) {
        Validators.validateNotNull(logger, "logger");
        return Configurator.configuratorForType(CoreModule.class, coreModule -> coreModule.setLogger(logger));
    }

    public static Configurator toLogToStdout() {
        return LoggerConfigurators.toLogUsing(Loggers.stdoutLogger());
    }

    public static Configurator toLogToStderr() {
        return LoggerConfigurators.toLogUsing(Loggers.stderrLogger());
    }

    public static Configurator toLogToStdoutAndStderr() {
        return LoggerConfigurators.toLogUsing(Loggers.stdoutAndStderrLogger());
    }

    public static Configurator toDropAllLogMessages() {
        return LoggerConfigurators.toLogUsing(Loggers.noLogger());
    }
}

