/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.marshalling;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.HttpMaidChains;
import de.quantummaid.httpmaid.chains.ChainExtender;
import de.quantummaid.httpmaid.chains.ChainModule;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.http.headers.ContentType;
import de.quantummaid.httpmaid.http.headers.accept.Accept;
import de.quantummaid.httpmaid.marshalling.Marshaller;
import de.quantummaid.httpmaid.marshalling.MarshallingException;
import de.quantummaid.httpmaid.marshalling.ResponseContentTypeCouldNotBeDeterminedException;
import de.quantummaid.httpmaid.marshalling.Unmarshaller;
import de.quantummaid.httpmaid.marshalling.UnsupportedContentTypeException;
import de.quantummaid.httpmaid.util.Validators;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class MarshallingModule
implements ChainModule {
    private volatile ContentType defaultContentType;
    private final Map<ContentType, Unmarshaller> unmarshallers;
    private final Map<ContentType, Marshaller> marshallers;
    private volatile boolean throwExceptionIfNoMarshallerFound;

    public static MarshallingModule emptyMarshallingModule() {
        return new MarshallingModule(new HashMap<ContentType, Unmarshaller>(), new HashMap<ContentType, Marshaller>());
    }

    public void addUnmarshaller(ContentType contentType, Unmarshaller unmarshaller) {
        Validators.validateNotNull(contentType, "contentType");
        Validators.validateNotNull(unmarshaller, "unmarshaller");
        this.unmarshallers.put(contentType, unmarshaller);
        if (this.defaultContentType == null) {
            this.defaultContentType = contentType;
        }
    }

    public void addMarshaller(ContentType contentType, Marshaller marshaller) {
        Validators.validateNotNull(contentType, "contentType");
        Validators.validateNotNull(marshaller, "marshaller");
        this.marshallers.put(contentType, marshaller);
        if (this.defaultContentType == null) {
            this.defaultContentType = contentType;
        }
    }

    public void setDefaultContentType(ContentType defaultContentType) {
        Validators.validateNotNull(defaultContentType, "defaultContentType");
        this.defaultContentType = defaultContentType;
    }

    public void setThrowExceptionIfNoMarshallerFound(boolean throwExceptionIfNoMarshallerFound) {
        this.throwExceptionIfNoMarshallerFound = throwExceptionIfNoMarshallerFound;
    }

    @Override
    public void register(ChainExtender extender) {
        extender.appendProcessor(HttpMaidChains.PROCESS_BODY_STRING, this::processUnmarshalling);
        extender.prependProcessor(HttpMaidChains.POST_INVOKE, this::processMarshalling);
    }

    private void processUnmarshalling(MetaData metaData) {
        metaData.getOptional(HttpMaidChainKeys.REQUEST_BODY_STRING).ifPresent(body -> {
            ContentType contentType = metaData.get(HttpMaidChainKeys.REQUEST_CONTENT_TYPE);
            Unmarshaller unmarshaller = contentType.isEmpty() ? this.unmarshallers.get(this.defaultContentType) : this.unmarshallers.get(contentType);
            if (Objects.isNull(unmarshaller)) {
                this.failIfConfiguredToDoSo(() -> UnsupportedContentTypeException.unsupportedContentTypeException(contentType, this.unmarshallers.keySet()));
            } else {
                Map mapBody = Optional.ofNullable(unmarshaller.unmarshall((String)body)).orElseGet(HashMap::new);
                metaData.set(HttpMaidChainKeys.REQUEST_BODY_MAP, mapBody);
            }
        });
    }

    private void processMarshalling(MetaData metaData) {
        block2: {
            try {
                metaData.getOptional(HttpMaidChainKeys.RESPONSE_BODY_MAP).ifPresent(map -> {
                    ContentType responseContentType = this.determineResponseContentType(metaData);
                    Marshaller marshaller = this.marshallerFor(responseContentType);
                    metaData.set(HttpMaidChainKeys.RESPONSE_CONTENT_TYPE, responseContentType);
                    String stringBody = marshaller.marshall((Map<String, Object>)map);
                    metaData.set(HttpMaidChainKeys.RESPONSE_BODY_STRING, stringBody);
                });
            }
            catch (MarshallingException e) {
                if (!metaData.getOptional(HttpMaidChainKeys.EXCEPTION).isEmpty()) break block2;
                this.failIfConfiguredToDoSo(() -> MarshallingException.marshallingException(e));
            }
        }
    }

    private Marshaller marshallerFor(ContentType responseContentType) {
        Marshaller marshaller = this.marshallers.get(responseContentType);
        if (Objects.isNull(marshaller)) {
            throw UnsupportedContentTypeException.unsupportedContentTypeException(responseContentType, this.marshallers.keySet());
        }
        return marshaller;
    }

    private ContentType determineResponseContentType(MetaData metaData) {
        Optional<ContentType> responseContentType = MarshallingModule.responseContentType(metaData);
        if (responseContentType.isPresent()) {
            return responseContentType.get();
        }
        Accept accept = Accept.fromMetaData(metaData);
        List candidates = this.marshallers.keySet().stream().filter(accept::contentTypeIsAccepted).collect(Collectors.toList());
        if (candidates.isEmpty()) {
            return this.defaultResponseContentType().orElseThrow(() -> ResponseContentTypeCouldNotBeDeterminedException.responseContentTypeCouldNotBeDeterminedException(metaData));
        }
        return metaData.getOptional(HttpMaidChainKeys.REQUEST_CONTENT_TYPE).filter(candidates::contains).orElseGet(() -> (ContentType)candidates.get(0));
    }

    private Optional<ContentType> defaultResponseContentType() {
        if (this.marshallers.isEmpty()) {
            return Optional.empty();
        }
        if (this.marshallers.containsKey(this.defaultContentType)) {
            return Optional.ofNullable(this.defaultContentType);
        }
        return Optional.ofNullable(this.marshallers.keySet().iterator().next());
    }

    private static Optional<ContentType> responseContentType(MetaData metaData) {
        return metaData.getOptional(HttpMaidChainKeys.RESPONSE_HEADERS).flatMap(headers -> {
            if (headers.containsKey("Content-Type")) {
                String contentType = (String)headers.get("Content-Type");
                return Optional.of(ContentType.fromString(contentType));
            }
            return Optional.empty();
        });
    }

    private void failIfConfiguredToDoSo(Supplier<RuntimeException> exceptionSupplier) {
        if (this.throwExceptionIfNoMarshallerFound) {
            throw exceptionSupplier.get();
        }
    }

    public String toString() {
        return "MarshallingModule(defaultContentType=" + this.defaultContentType + ", unmarshallers=" + this.unmarshallers + ", marshallers=" + this.marshallers + ", throwExceptionIfNoMarshallerFound=" + this.throwExceptionIfNoMarshallerFound + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MarshallingModule)) {
            return false;
        }
        MarshallingModule other = (MarshallingModule)o;
        ContentType this$defaultContentType = this.defaultContentType;
        ContentType other$defaultContentType = other.defaultContentType;
        if (this$defaultContentType == null ? other$defaultContentType != null : !((Object)this$defaultContentType).equals(other$defaultContentType)) {
            return false;
        }
        Map<ContentType, Unmarshaller> this$unmarshallers = this.unmarshallers;
        Map<ContentType, Unmarshaller> other$unmarshallers = other.unmarshallers;
        if (this$unmarshallers == null ? other$unmarshallers != null : !((Object)this$unmarshallers).equals(other$unmarshallers)) {
            return false;
        }
        Map<ContentType, Marshaller> this$marshallers = this.marshallers;
        Map<ContentType, Marshaller> other$marshallers = other.marshallers;
        if (this$marshallers == null ? other$marshallers != null : !((Object)this$marshallers).equals(other$marshallers)) {
            return false;
        }
        return this.throwExceptionIfNoMarshallerFound == other.throwExceptionIfNoMarshallerFound;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ContentType $defaultContentType = this.defaultContentType;
        result = result * 59 + ($defaultContentType == null ? 43 : ((Object)$defaultContentType).hashCode());
        Map<ContentType, Unmarshaller> $unmarshallers = this.unmarshallers;
        result = result * 59 + ($unmarshallers == null ? 43 : ((Object)$unmarshallers).hashCode());
        Map<ContentType, Marshaller> $marshallers = this.marshallers;
        result = result * 59 + ($marshallers == null ? 43 : ((Object)$marshallers).hashCode());
        result = result * 59 + (this.throwExceptionIfNoMarshallerFound ? 79 : 97);
        return result;
    }

    private MarshallingModule(Map<ContentType, Unmarshaller> unmarshallers, Map<ContentType, Marshaller> marshallers) {
        this.unmarshallers = unmarshallers;
        this.marshallers = marshallers;
    }
}

