/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.http.headers;

import lombok.Generated;

public final class HeaderValueWithComment {
    private final String value;
    private final String comment;

    public static HeaderValueWithComment fromString(String rawValue) {
        if (!rawValue.contains(";")) {
            return new HeaderValueWithComment(rawValue, "");
        }
        int semicolon = rawValue.indexOf(59);
        String value = rawValue.substring(0, semicolon);
        String comment = rawValue.substring(semicolon + 1);
        return new HeaderValueWithComment(value, comment);
    }

    public String value() {
        return this.value;
    }

    public String comment() {
        return this.comment;
    }

    public String valueWithComment() {
        if (this.comment == null || this.comment.isEmpty()) {
            return this.value();
        }
        return String.format("%s;%s", this.value, this.comment);
    }

    @Generated
    public String toString() {
        return "HeaderValueWithComment(value=" + this.value + ", comment=" + this.comment + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HeaderValueWithComment)) {
            return false;
        }
        HeaderValueWithComment other = (HeaderValueWithComment)o;
        String this$value = this.value;
        String other$value = other.value;
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Generated
    private HeaderValueWithComment(String value, String comment) {
        this.value = value;
        this.comment = comment;
    }
}

