/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.endpoint;

import de.quantummaid.httpmaid.http.Headers;
import de.quantummaid.httpmaid.http.QueryParameters;
import de.quantummaid.httpmaid.http.QueryParametersBuilder;
import de.quantummaid.httpmaid.websockets.endpoint.RawWebsocketConnect;
import de.quantummaid.httpmaid.websockets.registry.ConnectionInformation;
import de.quantummaid.httpmaid.websockets.sender.NonSerializableConnectionInformation;
import de.quantummaid.httpmaid.websockets.sender.NonSerializableWebsocketSender;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenderId;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public final class RawWebsocketConnectBuilder {
    private ConnectionInformation connectionInformation;
    private WebsocketSenderId websocketSenderId;
    private Headers headers;
    private QueryParameters queryParameters;

    public static RawWebsocketConnectBuilder rawWebsocketConnectBuilder() {
        return new RawWebsocketConnectBuilder();
    }

    public RawWebsocketConnectBuilder withNonSerializableConnectionInformation(NonSerializableConnectionInformation connectionInformation) {
        return this.withConnectionInformation(NonSerializableWebsocketSender.NON_SERIALIZABLE_WEBSOCKET_SENDER, connectionInformation);
    }

    public RawWebsocketConnectBuilder withConnectionInformation(WebsocketSenderId websocketSenderId, ConnectionInformation connectionInformation) {
        this.websocketSenderId = websocketSenderId;
        this.connectionInformation = connectionInformation;
        return this;
    }

    public RawWebsocketConnectBuilder withHeaders(Headers headers) {
        this.headers = headers;
        return this;
    }

    public RawWebsocketConnectBuilder withEncodedQueryString(String encodedQueryParameters) {
        return this.withQueryParameters(QueryParameters.fromQueryString(encodedQueryParameters));
    }

    private RawWebsocketConnectBuilder withQueryParameters(QueryParameters queryParameters) {
        this.queryParameters = queryParameters;
        return this;
    }

    public RawWebsocketConnectBuilder withQueryParameterMap(Map<String, List<String>> queryParameters) {
        QueryParametersBuilder builder = QueryParameters.builder();
        queryParameters.forEach(builder::withParameter);
        this.queryParameters = builder.build();
        return this;
    }

    public RawWebsocketConnect build() {
        return RawWebsocketConnect.rawWebsocketConnect(this.connectionInformation, this.websocketSenderId, this.queryParameters, this.headers);
    }

    @Generated
    public String toString() {
        return "RawWebsocketConnectBuilder(connectionInformation=" + this.connectionInformation + ", websocketSenderId=" + this.websocketSenderId + ", headers=" + this.headers + ", queryParameters=" + this.queryParameters + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawWebsocketConnectBuilder)) {
            return false;
        }
        RawWebsocketConnectBuilder other = (RawWebsocketConnectBuilder)o;
        ConnectionInformation this$connectionInformation = this.connectionInformation;
        ConnectionInformation other$connectionInformation = other.connectionInformation;
        if (this$connectionInformation == null ? other$connectionInformation != null : !this$connectionInformation.equals(other$connectionInformation)) {
            return false;
        }
        WebsocketSenderId this$websocketSenderId = this.websocketSenderId;
        WebsocketSenderId other$websocketSenderId = other.websocketSenderId;
        if (this$websocketSenderId == null ? other$websocketSenderId != null : !((Object)this$websocketSenderId).equals(other$websocketSenderId)) {
            return false;
        }
        Headers this$headers = this.headers;
        Headers other$headers = other.headers;
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        QueryParameters this$queryParameters = this.queryParameters;
        QueryParameters other$queryParameters = other.queryParameters;
        return !(this$queryParameters == null ? other$queryParameters != null : !((Object)this$queryParameters).equals(other$queryParameters));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConnectionInformation $connectionInformation = this.connectionInformation;
        result = result * 59 + ($connectionInformation == null ? 43 : $connectionInformation.hashCode());
        WebsocketSenderId $websocketSenderId = this.websocketSenderId;
        result = result * 59 + ($websocketSenderId == null ? 43 : ((Object)$websocketSenderId).hashCode());
        Headers $headers = this.headers;
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        QueryParameters $queryParameters = this.queryParameters;
        result = result * 59 + ($queryParameters == null ? 43 : ((Object)$queryParameters).hashCode());
        return result;
    }

    @Generated
    private RawWebsocketConnectBuilder() {
    }
}

