/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.chains.graph;

import de.quantummaid.httpmaid.chains.graph.Edge;
import de.quantummaid.httpmaid.chains.graph.Node;
import de.quantummaid.httpmaid.util.Validators;
import java.util.Collection;
import lombok.Generated;

public final class Graph {
    private final Collection<Node> nodes;
    private final Collection<Edge> edges;

    public static Graph graph(Collection<Node> nodes, Collection<Edge> edges) {
        Validators.validateNotNull(nodes, "nodes");
        Validators.validateNotNull(edges, "edges");
        return new Graph(nodes, edges);
    }

    public String plot() {
        StringBuilder builder = new StringBuilder();
        builder.append("digraph G {\n");
        builder.append("splines=ortho;\n");
        builder.append("CONSUME [shape=point, width=0.5];\n");
        this.nodes.stream().map(Node::plot).forEach(builder::append);
        this.edges.stream().map(Edge::plot).forEach(builder::append);
        builder.append("}\n");
        return builder.toString();
    }

    @Generated
    private Graph(Collection<Node> nodes, Collection<Edge> edges) {
        this.nodes = nodes;
        this.edges = edges;
    }
}

