/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.security;

import de.quantummaid.httpmaid.handler.http.HttpRequest;
import de.quantummaid.httpmaid.security.Filter;
import de.quantummaid.httpmaid.security.authentication.Authenticator;
import de.quantummaid.httpmaid.security.authentication.AuthenticatorConfigurator;
import de.quantummaid.httpmaid.security.authorization.AuthorizerConfigurator;
import de.quantummaid.httpmaid.security.authorization.HttpAuthorizer;
import de.quantummaid.httpmaid.security.basicauth.BasicAuthAuthenticator;
import de.quantummaid.httpmaid.security.basicauth.BasicAuthConfigurator;
import de.quantummaid.httpmaid.security.filtering.FilterConfigurator;
import de.quantummaid.httpmaid.security.oauth2.OAuth2Authenticator;
import de.quantummaid.httpmaid.util.Validators;

public final class SecurityConfigurators {
    private SecurityConfigurators() {
    }

    public static BasicAuthConfigurator toDoBasicAuthWith(BasicAuthAuthenticator authenticator) {
        return BasicAuthConfigurator.basicAuthenticationConfigurator(authenticator);
    }

    public static AuthenticatorConfigurator toAuthenticateRequestsUsing(Authenticator<HttpRequest> authenticator) {
        return AuthenticatorConfigurator.authenticatorConfigurator(metaData -> {
            HttpRequest request = HttpRequest.httpRequest(metaData);
            return authenticator.authenticate(request);
        });
    }

    public static AuthenticatorConfigurator toAuthenticateUsingOAuth2BearerToken(Authenticator<String> authenticator) {
        return SecurityConfigurators.toAuthenticateRequestsUsing(OAuth2Authenticator.oAuth2Authenticator(authenticator));
    }

    public static AuthenticatorConfigurator toAuthenticateUsingCookie(String cookieName, Authenticator<String> authenticator) {
        Validators.validateNotNullNorEmpty(cookieName, "cookieName");
        Validators.validateNotNull(authenticator, "authenticator");
        return SecurityConfigurators.toAuthenticateRequestsUsing(request -> request.cookies().getOptionalCookie(cookieName).flatMap(authenticator::authenticate));
    }

    public static AuthenticatorConfigurator toAuthenticateUsingHeader(String headerName, Authenticator<String> authenticator) {
        Validators.validateNotNullNorEmpty(headerName, "headerName");
        Validators.validateNotNull(authenticator, "authenticator");
        return SecurityConfigurators.toAuthenticateRequestsUsing(request -> request.headers().optionalHeader(headerName).flatMap(authenticator::authenticate));
    }

    public static AuthenticatorConfigurator toAuthenticateUsingQueryParameter(String parameterName, Authenticator<String> authenticator) {
        Validators.validateNotNullNorEmpty(parameterName, "parameterName");
        Validators.validateNotNull(authenticator, "authenticator");
        return SecurityConfigurators.toAuthenticateRequestsUsing(request -> request.queryParameters().optionalParameter(parameterName).flatMap(authenticator::authenticate));
    }

    public static AuthenticatorConfigurator toAuthenticateUsingPathParameter(String parameterName, Authenticator<String> authenticator) {
        Validators.validateNotNullNorEmpty(parameterName, "parameterName");
        Validators.validateNotNull(authenticator, "authenticator");
        return (AuthenticatorConfigurator)SecurityConfigurators.toAuthenticateRequestsUsing(request -> request.pathParameters().getOptionalPathParameter(parameterName).flatMap(authenticator::authenticate)).afterBodyProcessing();
    }

    public static AuthorizerConfigurator toAuthorizeRequestsUsing(HttpAuthorizer authorizer) {
        return AuthorizerConfigurator.authorizerConfigurator(authorizer);
    }

    public static AuthorizerConfigurator toAuthorizeAllAuthenticatedRequests() {
        return SecurityConfigurators.toAuthorizeRequestsUsing((authenticationInformation, request) -> authenticationInformation.isPresent());
    }

    public static FilterConfigurator toFilterRequestsThat(Filter filter) {
        return FilterConfigurator.filterConfigurator(filter);
    }
}

